/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.disruptor.publisher;

import java.util.ArrayList;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.core.concurrent.ConsistentHashSelector;
import org.dromara.hmily.core.concurrent.SingletonExecutor;
import org.dromara.hmily.core.coordinator.HmilyCoordinatorService;
import org.dromara.hmily.core.disruptor.DisruptorProviderManage;
import org.dromara.hmily.core.disruptor.event.HmilyTransactionEvent;
import org.dromara.hmily.core.disruptor.handler.HmilyConsumerLogDataHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class HmilyTransactionEventPublisher
implements ApplicationListener<ContextRefreshedEvent> {
    private DisruptorProviderManage<HmilyTransactionEvent> disruptorProviderManage;
    private final HmilyCoordinatorService coordinatorService;
    private final HmilyConfig hmilyConfig;

    @Autowired
    public HmilyTransactionEventPublisher(HmilyCoordinatorService coordinatorService, HmilyConfig hmilyConfig) {
        this.coordinatorService = coordinatorService;
        this.hmilyConfig = hmilyConfig;
    }

    private void start(int bufferSize, int threadSize) {
        ArrayList<SingletonExecutor> selects = new ArrayList<SingletonExecutor>();
        for (int i = 0; i < threadSize; ++i) {
            selects.add(new SingletonExecutor("hmily-log-disruptor" + i));
        }
        ConsistentHashSelector selector = new ConsistentHashSelector(selects);
        this.disruptorProviderManage = new DisruptorProviderManage(new HmilyConsumerLogDataHandler(selector, this.coordinatorService), 1, bufferSize);
        this.disruptorProviderManage.startup();
    }

    public void publishEvent(HmilyTransaction hmilyTransaction, int type) {
        HmilyTransactionEvent event = new HmilyTransactionEvent();
        event.setType(type);
        event.setHmilyTransaction(hmilyTransaction);
        this.disruptorProviderManage.getProvider().onData(event);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.start(this.hmilyConfig.getBufferSize(), this.hmilyConfig.getConsumerThreads());
    }
}

