/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.helper;

import org.apache.commons.lang3.StringUtils;
import org.dromara.hmily.common.utils.AssertUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;

public final class SpringBeanUtils {
    private static final SpringBeanUtils INSTANCE = new SpringBeanUtils();
    private ConfigurableApplicationContext cfgContext;

    private SpringBeanUtils() {
        if (INSTANCE != null) {
            throw new Error("error");
        }
    }

    public static SpringBeanUtils getInstance() {
        return INSTANCE;
    }

    public <T> T getBean(Class<T> type) {
        Object bean;
        AssertUtils.notNull(type);
        try {
            bean = this.cfgContext.getBean(type);
        }
        catch (BeansException e) {
            bean = this.getByName(type);
        }
        return (T)bean;
    }

    private <T> T getByName(Class<T> type) {
        String className = type.getSimpleName();
        Object bean = this.cfgContext.getBean(this.firstLowercase(SpringBeanUtils.firstDelete(className)), type);
        return (T)bean;
    }

    private String firstLowercase(String target) {
        if (StringUtils.isEmpty((CharSequence)target)) {
            return target;
        }
        char[] targetChar = target.toCharArray();
        targetChar[0] = (char)(targetChar[0] + 32);
        return String.valueOf(targetChar);
    }

    private static String firstDelete(String target) {
        if (StringUtils.isEmpty((CharSequence)target)) {
            return target;
        }
        return target.substring(1, target.length());
    }

    public void registerBean(String beanName, Object obj) {
        AssertUtils.notNull((Object)beanName);
        AssertUtils.notNull((Object)obj);
        this.cfgContext.getBeanFactory().registerSingleton(beanName, obj);
    }

    public void setCfgContext(ConfigurableApplicationContext cfgContext) {
        this.cfgContext = cfgContext;
    }
}

