/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.helper;

import org.dromara.hmily.common.utils.DbTypeUtils;

public class SqlHelper {
    public static String buildCreateTableSql(String driverClassName, String tableName) {
        String dbType;
        switch (dbType = DbTypeUtils.buildByDriverClassName((String)driverClassName)) {
            case "mysql": {
                return SqlHelper.buildMysql(tableName);
            }
            case "oracle": {
                return SqlHelper.buildOracle(tableName);
            }
            case "sqlserver": {
                return SqlHelper.buildSqlServer(tableName);
            }
            case "postgresql": {
                return SqlHelper.buildPostgresql(tableName);
            }
        }
        throw new RuntimeException("dbType not support ! The current support mysql oracle sqlserver postgresql.");
    }

    private static String buildMysql(String tableName) {
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "` (  `trans_id` varchar(64) NOT NULL,  `target_class` varchar(256) ,  `target_method` varchar(128) ,  `confirm_method` varchar(128) ,  `cancel_method` varchar(128) ,  `retried_count` tinyint NOT NULL,  `create_time` datetime NOT NULL,  `last_time` datetime NOT NULL,  `version` tinyint NOT NULL,  `status` tinyint NOT NULL,  `invocation` longblob,  `role` tinyint NOT NULL,  `pattern` tinyint,  PRIMARY KEY (`trans_id`))";
    }

    private static String buildOracle(String tableName) {
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "` (  `trans_id` varchar(64) NOT NULL,  `target_class` varchar(256) ,  `target_method` varchar(128) ,  `confirm_method` varchar(128) ,  `cancel_method` varchar(128) ,  `retried_count` int(3) NOT NULL,  `create_time` date NOT NULL,  `last_time` date NOT NULL,  `version` int(6) NOT NULL,  `status` int(2) NOT NULL,  `invocation` BLOB ,  `role` int(2) NOT NULL,  `pattern` int(2),  PRIMARY KEY (`trans_id`))";
    }

    private static String buildSqlServer(String tableName) {
        return "CREATE TABLE IF NOT EXISTS `" + tableName + "` (  `trans_id` varchar(64) NOT NULL,  `target_class` varchar(256) ,  `target_method` varchar(128) ,  `confirm_method` varchar(128) ,  `cancel_method` varchar(128) ,  `retried_count` int(3) NOT NULL,  `create_time` datetime NOT NULL,  `last_time` datetime NOT NULL,  `version` int(6) NOT NULL,  `status` int(2) NOT NULL,  `invocation` varbinary ,  `role` int(2) NOT NULL,  `pattern` int(2),  PRIMARY KEY (`trans_id`))";
    }

    private static String buildPostgresql(String tableName) {
        return " CREATE TABLE IF NOT EXISTS " + tableName + "(  trans_id       VARCHAR(64) PRIMARY KEY,  target_class   VARCHAR(256),  target_method  VARCHAR(128),  confirm_method VARCHAR(128),  cancel_method  VARCHAR(128),  retried_count  SMALLINT    NOT NULL,  create_time    TIMESTAMP   NOT NULL,  last_time      TIMESTAMP   NOT NULL,  version        SMALLINT    NOT NULL,  status         SMALLINT    NOT NULL,  invocation     BYTEA,  role           SMALLINT    NOT NULL,  pattern        SMALLINT    NOT NULL);";
    }
}

