/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.mediator;

import java.util.Objects;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.utils.GsonUtils;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.mediator.RpcAcquire;
import org.dromara.hmily.core.mediator.RpcTransmit;

public class RpcMediator {
    private static final RpcMediator RPC_MEDIATOR = new RpcMediator();

    public static RpcMediator getInstance() {
        return RPC_MEDIATOR;
    }

    public void transmit(RpcTransmit rpcTransmit, HmilyTransactionContext context) {
        if (Objects.nonNull(context)) {
            if (context.getRole() == HmilyRoleEnum.LOCAL.getCode()) {
                context.setRole(HmilyRoleEnum.INLINE.getCode());
            }
            rpcTransmit.transmit("HMILY_TRANSACTION_CONTEXT", GsonUtils.getInstance().toJson((Object)context));
        }
    }

    public HmilyTransactionContext acquire(RpcAcquire rpcAcquire) {
        HmilyTransactionContext hmilyTransactionContext = null;
        String context = rpcAcquire.acquire("HMILY_TRANSACTION_CONTEXT");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{context})) {
            hmilyTransactionContext = (HmilyTransactionContext)GsonUtils.getInstance().fromJson(context, HmilyTransactionContext.class);
        }
        return hmilyTransactionContext;
    }
}

