/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.schedule;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.hmily.annotation.PatternEnum;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.core.concurrent.threadpool.HmilyThreadFactory;
import org.dromara.hmily.core.helper.SpringBeanUtils;
import org.dromara.hmily.core.service.recovery.HmilyTransactionRecoveryService;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class HmilyTransactionSelfRecoveryScheduled
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmilyTransactionSelfRecoveryScheduled.class);
    private final HmilyConfig hmilyConfig;
    private ScheduledExecutorService scheduledExecutorService;
    private HmilyCoordinatorRepository hmilyCoordinatorRepository;
    private HmilyTransactionRecoveryService hmilyTransactionRecoveryService;

    @Autowired(required=false)
    public HmilyTransactionSelfRecoveryScheduled(HmilyConfig hmilyConfig) {
        this.hmilyConfig = hmilyConfig;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.hmilyCoordinatorRepository = SpringBeanUtils.getInstance().getBean(HmilyCoordinatorRepository.class);
        this.scheduledExecutorService = new ScheduledThreadPoolExecutor(1, HmilyThreadFactory.create("hmily-transaction-self-recovery", true));
        this.hmilyTransactionRecoveryService = new HmilyTransactionRecoveryService(this.hmilyCoordinatorRepository);
        this.selfRecovery();
    }

    private void selfRecovery() {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            LogUtil.info((Logger)LOGGER, (String)"self recovery execute delayTime:{}", () -> ((HmilyConfig)this.hmilyConfig).getScheduledDelay());
            try {
                List<HmilyTransaction> hmilyTransactions = this.hmilyCoordinatorRepository.listAllByDelay(this.acquireData());
                if (CollectionUtils.isEmpty(hmilyTransactions)) {
                    return;
                }
                for (HmilyTransaction hmilyTransaction : hmilyTransactions) {
                    if (hmilyTransaction.getRole() == HmilyRoleEnum.PROVIDER.getCode() && hmilyTransaction.getStatus() == HmilyActionEnum.PRE_TRY.getCode()) {
                        this.hmilyCoordinatorRepository.remove(hmilyTransaction.getTransId());
                        continue;
                    }
                    if (hmilyTransaction.getRetriedCount() > this.hmilyConfig.getRetryMax()) {
                        LogUtil.error((Logger)LOGGER, (String)"This transaction exceeds the maximum number of retries and no retries will occur\uff1a{}", () -> hmilyTransaction);
                        continue;
                    }
                    if (Objects.equals(hmilyTransaction.getPattern(), PatternEnum.CC.getCode()) && hmilyTransaction.getStatus() == HmilyActionEnum.TRYING.getCode() || hmilyTransaction.getRole() == HmilyRoleEnum.PROVIDER.getCode() && hmilyTransaction.getCreateTime().getTime() + (long)(this.hmilyConfig.getRecoverDelayTime() * this.hmilyConfig.getLoadFactor() * 1000) > System.currentTimeMillis()) continue;
                    hmilyTransaction.setRetriedCount(hmilyTransaction.getRetriedCount() + 1);
                    int rows = this.hmilyCoordinatorRepository.update(hmilyTransaction);
                    if (rows <= 0) continue;
                    if (hmilyTransaction.getStatus() == HmilyActionEnum.TRYING.getCode() || hmilyTransaction.getStatus() == HmilyActionEnum.PRE_TRY.getCode() || hmilyTransaction.getStatus() == HmilyActionEnum.CANCELING.getCode()) {
                        this.hmilyTransactionRecoveryService.cancel(hmilyTransaction);
                        continue;
                    }
                    if (hmilyTransaction.getStatus() != HmilyActionEnum.CONFIRMING.getCode()) continue;
                    this.hmilyTransactionRecoveryService.confirm(hmilyTransaction);
                }
            }
            catch (Exception e) {
                LOGGER.error("hmily scheduled transaction log is error:{}", (Throwable)e);
            }
        }, this.hmilyConfig.getScheduledInitDelay(), this.hmilyConfig.getScheduledDelay(), TimeUnit.SECONDS);
    }

    private Date acquireData() {
        return new Date(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() - (long)(this.hmilyConfig.getRecoverDelayTime() * 1000));
    }
}

