/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.service.executor;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.annotation.PatternEnum;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyInvocation;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.enums.EventTypeEnum;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.cache.HmilyTransactionGuavaCacheManager;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.disruptor.publisher.HmilyTransactionEventPublisher;
import org.dromara.hmily.core.reflect.HmilyReflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HmilyTransactionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmilyTransactionExecutor.class);
    private static final ThreadLocal<HmilyTransaction> CURRENT = new ThreadLocal();
    private final HmilyTransactionEventPublisher hmilyTransactionEventPublisher;

    @Autowired
    public HmilyTransactionExecutor(HmilyTransactionEventPublisher hmilyTransactionEventPublisher) {
        this.hmilyTransactionEventPublisher = hmilyTransactionEventPublisher;
    }

    public HmilyTransaction preTry(ProceedingJoinPoint point) {
        LogUtil.debug((Logger)LOGGER, () -> "......hmily transaction starter....");
        HmilyTransaction hmilyTransaction = this.buildHmilyTransaction(point, HmilyRoleEnum.START.getCode(), null);
        CURRENT.set(hmilyTransaction);
        this.hmilyTransactionEventPublisher.publishEvent(hmilyTransaction, EventTypeEnum.SAVE.getCode());
        HmilyTransactionContext context = new HmilyTransactionContext();
        context.setAction(HmilyActionEnum.TRYING.getCode());
        context.setTransId(hmilyTransaction.getTransId());
        context.setRole(HmilyRoleEnum.START.getCode());
        HmilyTransactionContextLocal.getInstance().set(context);
        return hmilyTransaction;
    }

    public HmilyTransaction preTryParticipant(HmilyTransactionContext context, ProceedingJoinPoint point) {
        LogUtil.debug((Logger)LOGGER, (String)"participant hmily transaction start..\uff1a{}", () -> ((HmilyTransactionContext)context).toString());
        HmilyTransaction hmilyTransaction = this.buildHmilyTransaction(point, HmilyRoleEnum.PROVIDER.getCode(), context.getTransId());
        HmilyTransactionGuavaCacheManager.getInstance().cacheHmilyTransaction(hmilyTransaction);
        this.hmilyTransactionEventPublisher.publishEvent(hmilyTransaction, EventTypeEnum.SAVE.getCode());
        context.setRole(HmilyRoleEnum.LOCAL.getCode());
        HmilyTransactionContextLocal.getInstance().set(context);
        return hmilyTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object confirm(HmilyTransaction currentTransaction) throws HmilyRuntimeException {
        LogUtil.debug((Logger)LOGGER, () -> "hmily transaction confirm .......\uff01start");
        if (Objects.isNull(currentTransaction) || CollectionUtils.isEmpty((Collection)currentTransaction.getHmilyParticipants())) {
            return null;
        }
        currentTransaction.setStatus(HmilyActionEnum.CONFIRMING.getCode());
        this.updateStatus(currentTransaction);
        List hmilyParticipants = currentTransaction.getHmilyParticipants();
        boolean success = true;
        if (CollectionUtils.isNotEmpty((Collection)hmilyParticipants)) {
            ArrayList failList = Lists.newArrayListWithCapacity((int)hmilyParticipants.size());
            ArrayList results = Lists.newArrayListWithCapacity((int)hmilyParticipants.size());
            for (HmilyParticipant hmilyParticipant : hmilyParticipants) {
                try {
                    Object result = HmilyReflector.executor(hmilyParticipant.getTransId(), HmilyActionEnum.CONFIRMING, hmilyParticipant.getConfirmHmilyInvocation());
                    results.add(result);
                }
                catch (Exception e) {
                    LogUtil.error((Logger)LOGGER, (String)"execute confirm :{}", () -> e);
                    success = false;
                    failList.add(hmilyParticipant);
                }
                finally {
                    HmilyTransactionContextLocal.getInstance().remove();
                }
            }
            this.executeHandler(success, currentTransaction, failList);
            return results.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cancel(HmilyTransaction currentTransaction) {
        LogUtil.debug((Logger)LOGGER, () -> "tcc cancel ...........start!");
        if (Objects.isNull(currentTransaction) || CollectionUtils.isEmpty((Collection)currentTransaction.getHmilyParticipants())) {
            return null;
        }
        if (currentTransaction.getStatus() == HmilyActionEnum.TRYING.getCode() && Objects.equals(currentTransaction.getPattern(), PatternEnum.CC.getCode())) {
            this.deleteTransaction(currentTransaction);
            return null;
        }
        currentTransaction.setStatus(HmilyActionEnum.CANCELING.getCode());
        this.updateStatus(currentTransaction);
        List<HmilyParticipant> hmilyParticipants = this.filterPoint(currentTransaction);
        boolean success = true;
        if (CollectionUtils.isNotEmpty(hmilyParticipants)) {
            ArrayList failList = Lists.newArrayListWithCapacity((int)hmilyParticipants.size());
            ArrayList results = Lists.newArrayListWithCapacity((int)hmilyParticipants.size());
            for (HmilyParticipant hmilyParticipant : hmilyParticipants) {
                try {
                    Object result = HmilyReflector.executor(hmilyParticipant.getTransId(), HmilyActionEnum.CANCELING, hmilyParticipant.getCancelHmilyInvocation());
                    results.add(result);
                }
                catch (Exception e) {
                    LogUtil.error((Logger)LOGGER, (String)"execute cancel ex:{}", () -> e);
                    success = false;
                    failList.add(hmilyParticipant);
                }
                finally {
                    HmilyTransactionContextLocal.getInstance().remove();
                }
            }
            this.executeHandler(success, currentTransaction, failList);
            return results.get(0);
        }
        return null;
    }

    public void updateStatus(HmilyTransaction hmilyTransaction) {
        this.hmilyTransactionEventPublisher.publishEvent(hmilyTransaction, EventTypeEnum.UPDATE_STATUS.getCode());
    }

    public void deleteTransaction(HmilyTransaction hmilyTransaction) {
        this.hmilyTransactionEventPublisher.publishEvent(hmilyTransaction, EventTypeEnum.DELETE.getCode());
    }

    public void updateParticipant(HmilyTransaction hmilyTransaction) {
        this.hmilyTransactionEventPublisher.publishEvent(hmilyTransaction, EventTypeEnum.UPDATE_PARTICIPANT.getCode());
    }

    public HmilyTransaction getCurrentTransaction() {
        return CURRENT.get();
    }

    public void remove() {
        CURRENT.remove();
    }

    public void enlistParticipant(HmilyParticipant hmilyParticipant) {
        if (Objects.isNull(hmilyParticipant)) {
            return;
        }
        Optional.ofNullable(this.getCurrentTransaction()).ifPresent(c -> {
            c.registerParticipant(hmilyParticipant);
            this.updateParticipant((HmilyTransaction)c);
        });
    }

    public void registerByNested(String transId, HmilyParticipant hmilyParticipant) {
        if (Objects.isNull(hmilyParticipant) || Objects.isNull(hmilyParticipant.getCancelHmilyInvocation()) || Objects.isNull(hmilyParticipant.getConfirmHmilyInvocation())) {
            return;
        }
        HmilyTransaction hmilyTransaction = HmilyTransactionGuavaCacheManager.getInstance().getHmilyTransaction(transId);
        Optional.ofNullable(hmilyTransaction).ifPresent(transaction -> {
            transaction.registerParticipant(hmilyParticipant);
            this.updateParticipant((HmilyTransaction)transaction);
        });
    }

    private void executeHandler(boolean success, HmilyTransaction currentTransaction, List<HmilyParticipant> failList) {
        HmilyTransactionGuavaCacheManager.getInstance().removeByKey(currentTransaction.getTransId());
        if (!success) {
            currentTransaction.setHmilyParticipants(failList);
            this.updateParticipant(currentTransaction);
            throw new HmilyRuntimeException(failList.toString());
        }
        this.deleteTransaction(currentTransaction);
    }

    private List<HmilyParticipant> filterPoint(HmilyTransaction currentTransaction) {
        List hmilyParticipants = currentTransaction.getHmilyParticipants();
        if (CollectionUtils.isNotEmpty((Collection)hmilyParticipants) && currentTransaction.getStatus() == HmilyActionEnum.TRYING.getCode() && currentTransaction.getRole() == HmilyRoleEnum.START.getCode()) {
            return hmilyParticipants.stream().limit(hmilyParticipants.size()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return hmilyParticipants;
    }

    private HmilyTransaction buildHmilyTransaction(ProceedingJoinPoint point, int role, String transId) {
        HmilyTransaction hmilyTransaction = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{transId}) ? new HmilyTransaction(transId) : new HmilyTransaction();
        hmilyTransaction.setStatus(HmilyActionEnum.PRE_TRY.getCode());
        hmilyTransaction.setRole(role);
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Class<?> clazz = point.getTarget().getClass();
        Object[] args = point.getArgs();
        Hmily hmily = method.getAnnotation(Hmily.class);
        PatternEnum pattern = hmily.pattern();
        hmilyTransaction.setTargetClass(clazz.getName());
        hmilyTransaction.setTargetMethod(method.getName());
        hmilyTransaction.setPattern(pattern.getCode());
        HmilyInvocation confirmInvocation = null;
        String confirmMethodName = hmily.confirmMethod();
        String cancelMethodName = hmily.cancelMethod();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{confirmMethodName})) {
            hmilyTransaction.setConfirmMethod(confirmMethodName);
            confirmInvocation = new HmilyInvocation(clazz, confirmMethodName, (Class[])method.getParameterTypes(), args);
        }
        HmilyInvocation cancelInvocation = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cancelMethodName})) {
            hmilyTransaction.setCancelMethod(cancelMethodName);
            cancelInvocation = new HmilyInvocation(clazz, cancelMethodName, (Class[])method.getParameterTypes(), args);
        }
        HmilyParticipant hmilyParticipant = new HmilyParticipant(hmilyTransaction.getTransId(), confirmInvocation, cancelInvocation);
        hmilyTransaction.registerParticipant(hmilyParticipant);
        return hmilyTransaction;
    }
}

