/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.service.handler;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hmily.annotation.Hmily;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyInvocation;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.service.HmilyTransactionHandler;
import org.dromara.hmily.core.service.executor.HmilyTransactionExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LocalHmilyTransactionHandler
implements HmilyTransactionHandler {
    private final HmilyTransactionExecutor hmilyTransactionExecutor;

    @Autowired
    public LocalHmilyTransactionHandler(HmilyTransactionExecutor hmilyTransactionExecutor) {
        this.hmilyTransactionExecutor = hmilyTransactionExecutor;
    }

    @Override
    public Object handler(ProceedingJoinPoint point, HmilyTransactionContext context) throws Throwable {
        if (HmilyActionEnum.TRYING.getCode() == context.getAction()) {
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            Class<?> clazz = point.getTarget().getClass();
            Object[] args = point.getArgs();
            Hmily hmily = method.getAnnotation(Hmily.class);
            HmilyInvocation confirmInvocation = null;
            String confirmMethodName = hmily.confirmMethod();
            String cancelMethodName = hmily.cancelMethod();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{confirmMethodName})) {
                confirmInvocation = new HmilyInvocation(clazz, confirmMethodName, (Class[])method.getParameterTypes(), args);
            }
            HmilyInvocation cancelInvocation = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{cancelMethodName})) {
                cancelInvocation = new HmilyInvocation(clazz, cancelMethodName, (Class[])method.getParameterTypes(), args);
            }
            HmilyParticipant hmilyParticipant = new HmilyParticipant(context.getTransId(), confirmInvocation, cancelInvocation);
            this.hmilyTransactionExecutor.registerByNested(context.getTransId(), hmilyParticipant);
        }
        return point.proceed();
    }
}

