/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.service.handler;

import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.utils.DefaultValueUtils;
import org.dromara.hmily.core.cache.HmilyTransactionGuavaCacheManager;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.service.HmilyTransactionHandler;
import org.dromara.hmily.core.service.executor.HmilyTransactionExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParticipantHmilyTransactionHandler
implements HmilyTransactionHandler {
    private final HmilyTransactionExecutor hmilyTransactionExecutor;

    @Autowired
    public ParticipantHmilyTransactionHandler(HmilyTransactionExecutor hmilyTransactionExecutor) {
        this.hmilyTransactionExecutor = hmilyTransactionExecutor;
    }

    @Override
    public Object handler(ProceedingJoinPoint point, HmilyTransactionContext context) throws Throwable {
        HmilyTransaction hmilyTransaction = null;
        switch (HmilyActionEnum.acquireByCode((int)context.getAction())) {
            case TRYING: {
                try {
                    hmilyTransaction = this.hmilyTransactionExecutor.preTryParticipant(context, point);
                    Object proceed = point.proceed();
                    hmilyTransaction.setStatus(HmilyActionEnum.TRYING.getCode());
                    this.hmilyTransactionExecutor.updateStatus(hmilyTransaction);
                    Object object = proceed;
                    return object;
                }
                catch (Throwable throwable) {
                    this.hmilyTransactionExecutor.deleteTransaction(hmilyTransaction);
                    throw throwable;
                }
                finally {
                    HmilyTransactionContextLocal.getInstance().remove();
                }
            }
            case CONFIRMING: {
                HmilyTransaction currentTransaction = HmilyTransactionGuavaCacheManager.getInstance().getHmilyTransaction(context.getTransId());
                return this.hmilyTransactionExecutor.confirm(currentTransaction);
            }
            case CANCELING: {
                HmilyTransaction currentTransaction = HmilyTransactionGuavaCacheManager.getInstance().getHmilyTransaction(context.getTransId());
                return this.hmilyTransactionExecutor.cancel(currentTransaction);
            }
        }
        Method method = ((MethodSignature)point.getSignature()).getMethod();
        return DefaultValueUtils.getDefaultValue(method.getReturnType());
    }
}

