/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.service.handler;

import org.aspectj.lang.ProceedingJoinPoint;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.disruptor.DisruptorProviderManage;
import org.dromara.hmily.core.disruptor.handler.HmilyConsumerTransactionDataHandler;
import org.dromara.hmily.core.service.HmilyTransactionHandler;
import org.dromara.hmily.core.service.HmilyTransactionHandlerAlbum;
import org.dromara.hmily.core.service.executor.HmilyTransactionExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class StarterHmilyTransactionHandler
implements HmilyTransactionHandler,
ApplicationListener<ContextRefreshedEvent> {
    private final HmilyTransactionExecutor hmilyTransactionExecutor;
    private final HmilyConfig hmilyConfig;
    private DisruptorProviderManage<HmilyTransactionHandlerAlbum> disruptorProviderManage;

    @Autowired
    public StarterHmilyTransactionHandler(HmilyTransactionExecutor hmilyTransactionExecutor, HmilyConfig hmilyConfig) {
        this.hmilyTransactionExecutor = hmilyTransactionExecutor;
        this.hmilyConfig = hmilyConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object handler(ProceedingJoinPoint point, HmilyTransactionContext context) throws Throwable {
        Object returnValue;
        try {
            HmilyTransaction hmilyTransaction = this.hmilyTransactionExecutor.preTry(point);
            try {
                returnValue = point.proceed();
                hmilyTransaction.setStatus(HmilyActionEnum.TRYING.getCode());
                this.hmilyTransactionExecutor.updateStatus(hmilyTransaction);
            }
            catch (Throwable throwable) {
                HmilyTransaction currentTransaction = this.hmilyTransactionExecutor.getCurrentTransaction();
                this.disruptorProviderManage.getProvider().onData(() -> this.hmilyTransactionExecutor.cancel(currentTransaction));
                throw throwable;
            }
            HmilyTransaction currentTransaction = this.hmilyTransactionExecutor.getCurrentTransaction();
            this.disruptorProviderManage.getProvider().onData(() -> this.hmilyTransactionExecutor.confirm(currentTransaction));
        }
        finally {
            HmilyTransactionContextLocal.getInstance().remove();
            this.hmilyTransactionExecutor.remove();
        }
        return returnValue;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.hmilyConfig.getStarted().booleanValue()) {
            this.disruptorProviderManage = new DisruptorProviderManage(new HmilyConsumerTransactionDataHandler(), this.hmilyConfig.getAsyncThreads(), DisruptorProviderManage.DEFAULT_SIZE);
            this.disruptorProviderManage.startup();
        }
    }
}

