/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.service.impl;

import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.serializer.ObjectSerializer;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.extension.ExtensionLoader;
import org.dromara.hmily.core.coordinator.HmilyCoordinatorService;
import org.dromara.hmily.core.helper.SpringBeanUtils;
import org.dromara.hmily.core.logo.HmilyLogo;
import org.dromara.hmily.core.service.HmilyInitService;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="hmilyInitService")
public class HmilyInitServiceImpl
implements HmilyInitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmilyInitServiceImpl.class);
    private final HmilyCoordinatorService hmilyCoordinatorService;

    @Autowired
    public HmilyInitServiceImpl(HmilyCoordinatorService hmilyCoordinatorService) {
        this.hmilyCoordinatorService = hmilyCoordinatorService;
    }

    @Override
    public void initialization(HmilyConfig hmilyConfig) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> LOGGER.info("hmily shutdown now")));
        try {
            this.loadSpiSupport(hmilyConfig);
            this.hmilyCoordinatorService.start(hmilyConfig);
        }
        catch (Exception ex) {
            LogUtil.error((Logger)LOGGER, (String)" hmily init exception:{}", ex::getMessage);
            System.exit(1);
        }
        new HmilyLogo().logo();
    }

    private void loadSpiSupport(HmilyConfig hmilyConfig) {
        ObjectSerializer serializer = (ObjectSerializer)ExtensionLoader.getExtensionLoader(ObjectSerializer.class).getActivateExtension(hmilyConfig.getSerializer());
        HmilyCoordinatorRepository repository = (HmilyCoordinatorRepository)ExtensionLoader.getExtensionLoader(HmilyCoordinatorRepository.class).getActivateExtension(hmilyConfig.getRepositorySupport());
        repository.setSerializer(serializer);
        SpringBeanUtils.getInstance().registerBean(HmilyCoordinatorRepository.class.getName(), repository);
    }
}

