/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.service.impl;

import java.util.Objects;
import org.dromara.hmily.common.bean.context.HmilyTransactionContext;
import org.dromara.hmily.common.enums.HmilyRoleEnum;
import org.dromara.hmily.core.service.HmilyTransactionFactoryService;
import org.dromara.hmily.core.service.handler.ConsumeHmilyTransactionHandler;
import org.dromara.hmily.core.service.handler.LocalHmilyTransactionHandler;
import org.dromara.hmily.core.service.handler.ParticipantHmilyTransactionHandler;
import org.dromara.hmily.core.service.handler.StarterHmilyTransactionHandler;
import org.springframework.stereotype.Service;

@Service(value="hmilyTransactionFactoryService")
public class HmilyTransactionFactoryServiceImpl
implements HmilyTransactionFactoryService {
    public Class factoryOf(HmilyTransactionContext context) {
        if (Objects.isNull(context)) {
            return StarterHmilyTransactionHandler.class;
        }
        if (context.getRole() == HmilyRoleEnum.SPRING_CLOUD.getCode()) {
            context.setRole(HmilyRoleEnum.START.getCode());
            return ConsumeHmilyTransactionHandler.class;
        }
        if (context.getRole() == HmilyRoleEnum.LOCAL.getCode()) {
            return LocalHmilyTransactionHandler.class;
        }
        if (context.getRole() == HmilyRoleEnum.START.getCode() || context.getRole() == HmilyRoleEnum.INLINE.getCode()) {
            return ParticipantHmilyTransactionHandler.class;
        }
        return ConsumeHmilyTransactionHandler.class;
    }
}

