/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.service.recovery;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dromara.hmily.common.bean.entity.HmilyParticipant;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.enums.HmilyActionEnum;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.core.concurrent.threadlocal.HmilyTransactionContextLocal;
import org.dromara.hmily.core.reflect.HmilyReflector;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmilyTransactionRecoveryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmilyTransactionRecoveryService.class);
    private HmilyCoordinatorRepository hmilyCoordinatorRepository;

    public HmilyTransactionRecoveryService(HmilyCoordinatorRepository hmilyCoordinatorRepository) {
        this.hmilyCoordinatorRepository = hmilyCoordinatorRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(HmilyTransaction hmilyTransaction) {
        List hmilyParticipants = hmilyTransaction.getHmilyParticipants();
        ArrayList failList = Lists.newArrayListWithCapacity((int)hmilyParticipants.size());
        boolean success = true;
        if (CollectionUtils.isNotEmpty((Collection)hmilyParticipants)) {
            for (HmilyParticipant hmilyParticipant : hmilyParticipants) {
                try {
                    HmilyReflector.executor(hmilyParticipant.getTransId(), HmilyActionEnum.CANCELING, hmilyParticipant.getCancelHmilyInvocation());
                }
                catch (Exception e) {
                    LogUtil.error((Logger)LOGGER, (String)"execute cancel exception:{}", () -> e);
                    success = false;
                    failList.add(hmilyParticipant);
                }
                finally {
                    HmilyTransactionContextLocal.getInstance().remove();
                }
            }
            this.executeHandler(success, hmilyTransaction, failList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirm(HmilyTransaction hmilyTransaction) {
        List hmilyParticipants = hmilyTransaction.getHmilyParticipants();
        ArrayList failList = Lists.newArrayListWithCapacity((int)hmilyParticipants.size());
        boolean success = true;
        if (CollectionUtils.isNotEmpty((Collection)hmilyParticipants)) {
            for (HmilyParticipant hmilyParticipant : hmilyParticipants) {
                try {
                    HmilyReflector.executor(hmilyParticipant.getTransId(), HmilyActionEnum.CONFIRMING, hmilyParticipant.getConfirmHmilyInvocation());
                }
                catch (Exception e) {
                    LogUtil.error((Logger)LOGGER, (String)"execute confirm exception:{}", () -> e);
                    success = false;
                    failList.add(hmilyParticipant);
                }
                finally {
                    HmilyTransactionContextLocal.getInstance().remove();
                }
            }
            this.executeHandler(success, hmilyTransaction, failList);
        }
    }

    private void executeHandler(boolean success, HmilyTransaction currentTransaction, List<HmilyParticipant> failList) {
        if (success) {
            this.deleteTransaction(currentTransaction.getTransId());
        } else {
            currentTransaction.setHmilyParticipants(failList);
            this.hmilyCoordinatorRepository.updateParticipant(currentTransaction);
        }
    }

    private void deleteTransaction(String transId) {
        this.hmilyCoordinatorRepository.remove(transId);
    }
}

