/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.spi.repository;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.bean.adapter.CoordinatorRepositoryAdapter;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.enums.RepositorySupportEnum;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.serializer.ObjectSerializer;
import org.dromara.hmily.common.utils.FileUtils;
import org.dromara.hmily.common.utils.RepositoryConvertUtils;
import org.dromara.hmily.common.utils.RepositoryPathUtils;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;

@HmilySPI(value="file")
public class FileCoordinatorRepository
implements HmilyCoordinatorRepository {
    private static volatile boolean initialized;
    private String filePath;
    private ObjectSerializer serializer;

    @Override
    public void setSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public int create(HmilyTransaction hmilyTransaction) {
        this.writeFile(hmilyTransaction);
        return 1;
    }

    @Override
    public int remove(String id) {
        String fullFileName = RepositoryPathUtils.getFullFileName((String)this.filePath, (String)id);
        File file = new File(fullFileName);
        if (file.exists()) {
            file.delete();
        }
        return 1;
    }

    @Override
    public int update(HmilyTransaction hmilyTransaction) throws HmilyRuntimeException {
        hmilyTransaction.setLastTime(new Date());
        hmilyTransaction.setVersion(Integer.valueOf(hmilyTransaction.getVersion() + 1));
        hmilyTransaction.setRetriedCount(hmilyTransaction.getRetriedCount() + 1);
        try {
            this.writeFile(hmilyTransaction);
        }
        catch (Exception e) {
            throw new HmilyRuntimeException("update data exception!");
        }
        return 1;
    }

    @Override
    public int updateParticipant(HmilyTransaction hmilyTransaction) {
        try {
            String fullFileName = RepositoryPathUtils.getFullFileName((String)this.filePath, (String)hmilyTransaction.getTransId());
            File file = new File(fullFileName);
            CoordinatorRepositoryAdapter adapter = this.readAdapter(file);
            if (Objects.nonNull(adapter)) {
                adapter.setContents(this.serializer.serialize((Object)hmilyTransaction.getHmilyParticipants()));
            }
            FileUtils.writeFile((String)fullFileName, (byte[])this.serializer.serialize((Object)adapter));
        }
        catch (Exception e) {
            throw new HmilyRuntimeException("update data exception!");
        }
        return 1;
    }

    @Override
    public int updateStatus(String id, Integer status) {
        try {
            String fullFileName = RepositoryPathUtils.getFullFileName((String)this.filePath, (String)id);
            File file = new File(fullFileName);
            CoordinatorRepositoryAdapter adapter = this.readAdapter(file);
            if (Objects.nonNull(adapter)) {
                adapter.setStatus(status.intValue());
            }
            FileUtils.writeFile((String)fullFileName, (byte[])this.serializer.serialize((Object)adapter));
        }
        catch (Exception e) {
            throw new HmilyRuntimeException("update data exception!");
        }
        return 1;
    }

    @Override
    public HmilyTransaction findById(String id) {
        String fullFileName = RepositoryPathUtils.getFullFileName((String)this.filePath, (String)id);
        File file = new File(fullFileName);
        try {
            return this.readTransaction(file);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<HmilyTransaction> listAll() {
        ArrayList transactionRecoverList = Lists.newArrayList();
        File path = new File(this.filePath);
        File[] files = path.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                try {
                    HmilyTransaction transaction = this.readTransaction(file);
                    transactionRecoverList.add(transaction);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return transactionRecoverList;
    }

    @Override
    public List<HmilyTransaction> listAllByDelay(Date date) {
        List<HmilyTransaction> hmilyTransactions = this.listAll();
        return hmilyTransactions.stream().filter(tccTransaction -> tccTransaction.getLastTime().compareTo(date) < 0).collect(Collectors.toList());
    }

    @Override
    public void init(String modelName, HmilyConfig hmilyConfig) {
        this.filePath = RepositoryPathUtils.buildFilePath((String)modelName);
        File file = new File(this.filePath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.mkdirs();
        }
    }

    @Override
    public String getScheme() {
        return RepositorySupportEnum.FILE.getSupport();
    }

    private void writeFile(HmilyTransaction hmilyTransaction) {
        this.makeDir();
        String fileName = RepositoryPathUtils.getFullFileName((String)this.filePath, (String)hmilyTransaction.getTransId());
        try {
            FileUtils.writeFile((String)fileName, (byte[])RepositoryConvertUtils.convert((HmilyTransaction)hmilyTransaction, (ObjectSerializer)this.serializer));
        }
        catch (HmilyException e) {
            e.printStackTrace();
        }
    }

    private HmilyTransaction readTransaction(File file) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] content = new byte[(int)file.length()];
            fis.read(content);
            HmilyTransaction hmilyTransaction = RepositoryConvertUtils.transformBean((byte[])content, (ObjectSerializer)this.serializer);
            return hmilyTransaction;
        }
    }

    private CoordinatorRepositoryAdapter readAdapter(File file) throws Exception {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] content = new byte[(int)file.length()];
            fis.read(content);
            CoordinatorRepositoryAdapter coordinatorRepositoryAdapter = (CoordinatorRepositoryAdapter)this.serializer.deSerialize(content, CoordinatorRepositoryAdapter.class);
            return coordinatorRepositoryAdapter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void makeDir() {
        if (initialized) return;
        Class<FileCoordinatorRepository> clazz = FileCoordinatorRepository.class;
        synchronized (FileCoordinatorRepository.class) {
            if (initialized) return;
            File rootPathFile = new File(this.filePath);
            if (!rootPathFile.exists()) {
                boolean result = rootPathFile.mkdir();
                if (!result) {
                    throw new HmilyRuntimeException("cannot create root path, the path to create is:" + this.filePath);
                }
                initialized = true;
            } else {
                if (rootPathFile.isDirectory()) return;
                throw new HmilyRuntimeException("rootPath is not directory");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

