/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.spi.repository;

import com.google.common.collect.Maps;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.config.HmilyDbConfig;
import org.dromara.hmily.common.enums.RepositorySupportEnum;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.serializer.ObjectSerializer;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.DbTypeUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.RepositoryPathUtils;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.helper.SqlHelper;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="db")
public class JdbcCoordinatorRepository
implements HmilyCoordinatorRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbcCoordinatorRepository.class);
    private DataSource dataSource;
    private String tableName;
    private String currentDBType;
    private ObjectSerializer serializer;

    @Override
    public void setSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public int create(HmilyTransaction hmilyTransaction) {
        String sql = "insert into " + this.tableName + "(trans_id,target_class,target_method,retried_count,create_time,last_time,version,status,invocation,role,pattern,confirm_method,cancel_method) values(?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try {
            byte[] serialize = this.serializer.serialize((Object)hmilyTransaction.getHmilyParticipants());
            return this.executeUpdate(sql, hmilyTransaction.getTransId(), hmilyTransaction.getTargetClass(), hmilyTransaction.getTargetMethod(), hmilyTransaction.getRetriedCount(), hmilyTransaction.getCreateTime(), hmilyTransaction.getLastTime(), hmilyTransaction.getVersion(), hmilyTransaction.getStatus(), serialize, hmilyTransaction.getRole(), hmilyTransaction.getPattern(), hmilyTransaction.getConfirmMethod(), hmilyTransaction.getCancelMethod());
        }
        catch (HmilyException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int remove(String id) {
        String sql = "delete from " + this.tableName + " where trans_id = ? ";
        return this.executeUpdate(sql, id);
    }

    @Override
    public int update(HmilyTransaction hmilyTransaction) {
        Integer currentVersion = hmilyTransaction.getVersion();
        hmilyTransaction.setLastTime(new Date());
        hmilyTransaction.setVersion(Integer.valueOf(hmilyTransaction.getVersion() + 1));
        String sql = "update " + this.tableName + " set last_time = ?,version =?,retried_count =?,invocation=?,status=? ,pattern=? where trans_id = ? and version=? ";
        try {
            byte[] serialize = this.serializer.serialize((Object)hmilyTransaction.getHmilyParticipants());
            return this.executeUpdate(sql, hmilyTransaction.getLastTime(), hmilyTransaction.getVersion(), hmilyTransaction.getRetriedCount(), serialize, hmilyTransaction.getStatus(), hmilyTransaction.getPattern(), hmilyTransaction.getTransId(), currentVersion);
        }
        catch (HmilyException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int updateParticipant(HmilyTransaction hmilyTransaction) {
        String sql = "update " + this.tableName + " set invocation=?  where trans_id = ?  ";
        try {
            byte[] serialize = this.serializer.serialize((Object)hmilyTransaction.getHmilyParticipants());
            return this.executeUpdate(sql, serialize, hmilyTransaction.getTransId());
        }
        catch (HmilyException e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int updateStatus(String id, Integer status) {
        String sql = "update " + this.tableName + " set status=?  where trans_id = ?  ";
        return this.executeUpdate(sql, status, id);
    }

    @Override
    public HmilyTransaction findById(String id) {
        String selectSql = "select * from " + this.tableName + " where trans_id=?";
        List<Map<String, Object>> list = this.executeQuery(selectSql, id);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().filter(Objects::nonNull).map(this::buildByResultMap).findFirst().orElse(null);
        }
        return null;
    }

    @Override
    public List<HmilyTransaction> listAll() {
        String selectSql = "select * from " + this.tableName;
        List<Map<String, Object>> list = this.executeQuery(selectSql, new Object[0]);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().filter(Objects::nonNull).map(this::buildByResultMap).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<HmilyTransaction> listAllByDelay(Date date) {
        String sb = "select * from " + this.tableName + " where last_time <?";
        List<Map<String, Object>> list = this.executeQuery(sb, date);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.stream().filter(Objects::nonNull).map(this::buildByResultMap).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private HmilyTransaction buildByResultMap(Map<String, Object> map) {
        HmilyTransaction hmilyTransaction = new HmilyTransaction();
        hmilyTransaction.setTransId((String)map.get("trans_id"));
        hmilyTransaction.setRetriedCount(((Integer)map.get("retried_count")).intValue());
        hmilyTransaction.setCreateTime((Date)map.get("create_time"));
        hmilyTransaction.setLastTime((Date)map.get("last_time"));
        hmilyTransaction.setVersion((Integer)map.get("version"));
        hmilyTransaction.setStatus(((Integer)map.get("status")).intValue());
        hmilyTransaction.setRole(((Integer)map.get("role")).intValue());
        hmilyTransaction.setPattern((Integer)map.get("pattern"));
        byte[] bytes = (byte[])map.get("invocation");
        try {
            List hmilyParticipants = (List)this.serializer.deSerialize(bytes, CopyOnWriteArrayList.class);
            hmilyTransaction.setHmilyParticipants(hmilyParticipants);
        }
        catch (HmilyException e) {
            e.printStackTrace();
        }
        return hmilyTransaction;
    }

    @Override
    public void init(String modelName, HmilyConfig txConfig) {
        try {
            HmilyDbConfig hmilyDbConfig = txConfig.getHmilyDbConfig();
            if (hmilyDbConfig.getDataSource() != null && StringUtils.isBlank((CharSequence)hmilyDbConfig.getUrl())) {
                this.dataSource = hmilyDbConfig.getDataSource();
            } else {
                HikariDataSource hikariDataSource = new HikariDataSource();
                hikariDataSource.setJdbcUrl(hmilyDbConfig.getUrl());
                hikariDataSource.setDriverClassName(hmilyDbConfig.getDriverClassName());
                hikariDataSource.setUsername(hmilyDbConfig.getUsername());
                hikariDataSource.setPassword(hmilyDbConfig.getPassword());
                hikariDataSource.setMaximumPoolSize(hmilyDbConfig.getMaxActive());
                hikariDataSource.setMinimumIdle(hmilyDbConfig.getMinIdle());
                hikariDataSource.setConnectionTimeout(hmilyDbConfig.getConnectionTimeout());
                hikariDataSource.setIdleTimeout(hmilyDbConfig.getIdleTimeout());
                hikariDataSource.setMaxLifetime(hmilyDbConfig.getMaxLifetime());
                hikariDataSource.setConnectionTestQuery(hmilyDbConfig.getConnectionTestQuery());
                if (hmilyDbConfig.getDataSourcePropertyMap() != null && !hmilyDbConfig.getDataSourcePropertyMap().isEmpty()) {
                    hmilyDbConfig.getDataSourcePropertyMap().forEach((arg_0, arg_1) -> ((HikariDataSource)hikariDataSource).addDataSourceProperty(arg_0, arg_1));
                }
                this.dataSource = hikariDataSource;
            }
            this.tableName = RepositoryPathUtils.buildDbTableName((String)modelName);
            this.currentDBType = DbTypeUtils.buildByDriverClassName((String)hmilyDbConfig.getDriverClassName());
            this.executeUpdate(SqlHelper.buildCreateTableSql(hmilyDbConfig.getDriverClassName(), this.tableName), new Object[0]);
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOGGER, (String)"hmily jdbc log init exception please check config:{}", e::getMessage);
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getScheme() {
        return RepositorySupportEnum.DB.getSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdate(String sql, Object ... params) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            int i;
            connection = this.dataSource.getConnection();
            ps = connection.prepareStatement(sql);
            if (params != null) {
                for (i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, this.convertDataTypeToDB(params[i]));
                }
            }
            i = ps.executeUpdate();
            this.close(connection, ps, null);
            return i;
        }
        catch (SQLException e) {
            try {
                LOGGER.error("executeUpdate-> " + e.getMessage());
                int n = 0;
                this.close(connection, ps, null);
                return n;
            }
            catch (Throwable throwable) {
                this.close(connection, ps, null);
                throw throwable;
            }
        }
    }

    private Object convertDataTypeToDB(Object params) {
        if ("postgresql".equals(this.currentDBType) && params instanceof Date) {
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(((Date)params).getTime()), ZoneId.systemDefault());
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> executeQuery(String sql, Object ... params) {
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<HashMap> list = null;
        try {
            connection = this.dataSource.getConnection();
            ps = connection.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    ps.setObject(i + 1, this.convertDataTypeToDB(params[i]));
                }
            }
            rs = ps.executeQuery();
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            list = new ArrayList<HashMap>();
            while (rs.next()) {
                HashMap rowData = Maps.newHashMap();
                for (int i = 1; i <= columnCount; ++i) {
                    rowData.put(md.getColumnName(i), rs.getObject(i));
                }
                list.add(rowData);
            }
            this.close(connection, ps, rs);
        }
        catch (SQLException e) {
            try {
                LOGGER.error("executeQuery-> " + e.getMessage());
                this.close(connection, ps, rs);
            }
            catch (Throwable throwable) {
                this.close(connection, ps, rs);
                throw throwable;
            }
        }
        return list;
    }

    private void close(Connection con, PreparedStatement ps, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        try {
            if (ps != null) {
                ps.close();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }
}

