/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.spi.repository;

import com.google.common.base.Splitter;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.result.UpdateResult;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.bean.adapter.MongoAdapter;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.config.HmilyMongoConfig;
import org.dromara.hmily.common.enums.RepositorySupportEnum;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.serializer.ObjectSerializer;
import org.dromara.hmily.common.utils.AssertUtils;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.RepositoryPathUtils;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoClientFactoryBean;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

@HmilySPI(value="mongodb")
public class MongoCoordinatorRepository
implements HmilyCoordinatorRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoCoordinatorRepository.class);
    private ObjectSerializer objectSerializer;
    private MongoTemplate template;
    private String collectionName;

    @Override
    public int create(HmilyTransaction hmilyTransaction) {
        try {
            MongoAdapter mongoBean = new MongoAdapter();
            mongoBean.setTransId(hmilyTransaction.getTransId());
            mongoBean.setCreateTime(hmilyTransaction.getCreateTime());
            mongoBean.setLastTime(hmilyTransaction.getLastTime());
            mongoBean.setRetriedCount(hmilyTransaction.getRetriedCount());
            mongoBean.setStatus(hmilyTransaction.getStatus());
            mongoBean.setRole(hmilyTransaction.getRole());
            mongoBean.setPattern(hmilyTransaction.getPattern());
            mongoBean.setTargetClass(hmilyTransaction.getTargetClass());
            mongoBean.setTargetMethod(hmilyTransaction.getTargetMethod());
            mongoBean.setConfirmMethod(hmilyTransaction.getConfirmMethod());
            mongoBean.setCancelMethod(hmilyTransaction.getCancelMethod());
            byte[] cache = this.objectSerializer.serialize((Object)hmilyTransaction.getHmilyParticipants());
            mongoBean.setContents(cache);
            this.template.save((Object)mongoBean, this.collectionName);
        }
        catch (HmilyException e) {
            e.printStackTrace();
        }
        return 1;
    }

    @Override
    public int remove(String id) {
        AssertUtils.notNull((Object)id);
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)new Criteria("transId").is((Object)id));
        this.template.remove(query, this.collectionName);
        return 1;
    }

    @Override
    public int update(HmilyTransaction hmilyTransaction) throws HmilyRuntimeException {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)new Criteria("transId").is((Object)hmilyTransaction.getTransId()));
        Update update = new Update();
        update.set("lastTime", (Object)new Date());
        update.set("retriedCount", (Object)hmilyTransaction.getRetriedCount());
        update.set("version", (Object)(hmilyTransaction.getVersion() + 1));
        try {
            if (CollectionUtils.isNotEmpty((Collection)hmilyTransaction.getHmilyParticipants())) {
                update.set("contents", (Object)this.objectSerializer.serialize((Object)hmilyTransaction.getHmilyParticipants()));
            }
        }
        catch (HmilyException e) {
            e.printStackTrace();
        }
        UpdateResult updateResult = this.template.updateFirst(query, update, MongoAdapter.class, this.collectionName);
        if (updateResult.getModifiedCount() <= 0L) {
            throw new HmilyRuntimeException("update data exception!");
        }
        return 1;
    }

    @Override
    public int updateParticipant(HmilyTransaction hmilyTransaction) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)new Criteria("transId").is((Object)hmilyTransaction.getTransId()));
        Update update = new Update();
        try {
            update.set("contents", (Object)this.objectSerializer.serialize((Object)hmilyTransaction.getHmilyParticipants()));
        }
        catch (HmilyException e) {
            e.printStackTrace();
        }
        UpdateResult updateResult = this.template.updateFirst(query, update, MongoAdapter.class, this.collectionName);
        if (updateResult.getModifiedCount() <= 0L) {
            throw new HmilyRuntimeException("update data exception!");
        }
        return 1;
    }

    @Override
    public int updateStatus(String id, Integer status) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)new Criteria("transId").is((Object)id));
        Update update = new Update();
        update.set("status", (Object)status);
        UpdateResult updateResult = this.template.updateFirst(query, update, MongoAdapter.class, this.collectionName);
        if (updateResult.getModifiedCount() <= 0L) {
            throw new HmilyRuntimeException("update data exception!");
        }
        return 1;
    }

    @Override
    public HmilyTransaction findById(String id) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)new Criteria("transId").is((Object)id));
        MongoAdapter cache = (MongoAdapter)this.template.findOne(query, MongoAdapter.class, this.collectionName);
        return this.buildByCache(Objects.requireNonNull(cache));
    }

    private HmilyTransaction buildByCache(MongoAdapter cache) {
        try {
            HmilyTransaction hmilyTransaction = new HmilyTransaction();
            hmilyTransaction.setTransId(cache.getTransId());
            hmilyTransaction.setCreateTime(cache.getCreateTime());
            hmilyTransaction.setLastTime(cache.getLastTime());
            hmilyTransaction.setRetriedCount(cache.getRetriedCount());
            hmilyTransaction.setVersion(cache.getVersion());
            hmilyTransaction.setStatus(cache.getStatus());
            hmilyTransaction.setRole(cache.getRole());
            hmilyTransaction.setPattern(cache.getPattern());
            hmilyTransaction.setTargetClass(cache.getTargetClass());
            hmilyTransaction.setTargetMethod(cache.getTargetMethod());
            List hmilyParticipants = (List)this.objectSerializer.deSerialize(cache.getContents(), CopyOnWriteArrayList.class);
            hmilyTransaction.setHmilyParticipants(hmilyParticipants);
            return hmilyTransaction;
        }
        catch (HmilyException e) {
            LogUtil.error((Logger)LOGGER, (String)"mongodb deSerialize exception:{}", e::getLocalizedMessage);
            return null;
        }
    }

    @Override
    public List<HmilyTransaction> listAll() {
        List resultList = this.template.findAll(MongoAdapter.class, this.collectionName);
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            return resultList.stream().map(this::buildByCache).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<HmilyTransaction> listAllByDelay(Date date) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"lastTime").lt((Object)date));
        List mongoBeans = this.template.find(query, MongoAdapter.class, this.collectionName);
        if (CollectionUtils.isNotEmpty((Collection)mongoBeans)) {
            return mongoBeans.stream().map(this::buildByCache).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public void init(String modelName, HmilyConfig hmilyConfig) {
        this.collectionName = RepositoryPathUtils.buildMongoTableName((String)modelName);
        HmilyMongoConfig hmilyMongoConfig = hmilyConfig.getHmilyMongoConfig();
        MongoClientFactoryBean clientFactoryBean = this.buildMongoClientFactoryBean(hmilyMongoConfig);
        try {
            clientFactoryBean.afterPropertiesSet();
            this.template = new MongoTemplate((MongoClient)Objects.requireNonNull(clientFactoryBean.getObject()), hmilyMongoConfig.getMongoDbName());
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOGGER, (String)"mongo init error please check you config:{}", e::getMessage);
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    private MongoClientFactoryBean buildMongoClientFactoryBean(HmilyMongoConfig hmilyMongoConfig) {
        MongoClientFactoryBean clientFactoryBean = new MongoClientFactoryBean();
        MongoCredential credential = MongoCredential.createScramSha1Credential((String)hmilyMongoConfig.getMongoUserName(), (String)hmilyMongoConfig.getMongoDbName(), (char[])hmilyMongoConfig.getMongoUserPwd().toCharArray());
        clientFactoryBean.setCredentials(new MongoCredential[]{credential});
        List urls = Splitter.on((String)",").trimResults().splitToList((CharSequence)hmilyMongoConfig.getMongoDbUrl());
        ServerAddress[] sds = new ServerAddress[urls.size()];
        for (int i = 0; i < sds.length; ++i) {
            List adds = Splitter.on((String)":").trimResults().splitToList((CharSequence)urls.get(i));
            InetSocketAddress address = new InetSocketAddress((String)adds.get(0), Integer.parseInt((String)adds.get(1)));
            sds[i] = new ServerAddress(address);
        }
        clientFactoryBean.setReplicaSetSeeds(sds);
        return clientFactoryBean;
    }

    @Override
    public String getScheme() {
        return RepositorySupportEnum.MONGODB.getSupport();
    }

    @Override
    public void setSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }
}

