/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.spi.repository;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.bean.adapter.CoordinatorRepositoryAdapter;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.config.HmilyRedisConfig;
import org.dromara.hmily.common.enums.RepositorySupportEnum;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.jedis.JedisClient;
import org.dromara.hmily.common.jedis.JedisClientCluster;
import org.dromara.hmily.common.jedis.JedisClientSentinel;
import org.dromara.hmily.common.jedis.JedisClientSingle;
import org.dromara.hmily.common.serializer.ObjectSerializer;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.RepositoryConvertUtils;
import org.dromara.hmily.common.utils.RepositoryPathUtils;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

@HmilySPI(value="redis")
public class RedisCoordinatorRepository
implements HmilyCoordinatorRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisCoordinatorRepository.class);
    private ObjectSerializer objectSerializer;
    private JedisClient jedisClient;
    private String keyPrefix;

    @Override
    public int create(HmilyTransaction hmilyTransaction) {
        try {
            String redisKey = RepositoryPathUtils.buildRedisKey((String)this.keyPrefix, (String)hmilyTransaction.getTransId());
            this.jedisClient.set(redisKey, RepositoryConvertUtils.convert((HmilyTransaction)hmilyTransaction, (ObjectSerializer)this.objectSerializer));
            return 1;
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public int remove(String id) {
        try {
            String redisKey = RepositoryPathUtils.buildRedisKey((String)this.keyPrefix, (String)id);
            return this.jedisClient.del(new String[]{redisKey}).intValue();
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public int update(HmilyTransaction hmilyTransaction) throws HmilyRuntimeException {
        try {
            String redisKey = RepositoryPathUtils.buildRedisKey((String)this.keyPrefix, (String)hmilyTransaction.getTransId());
            hmilyTransaction.setVersion(Integer.valueOf(hmilyTransaction.getVersion() + 1));
            hmilyTransaction.setLastTime(new Date());
            hmilyTransaction.setRetriedCount(hmilyTransaction.getRetriedCount());
            this.jedisClient.set(redisKey, RepositoryConvertUtils.convert((HmilyTransaction)hmilyTransaction, (ObjectSerializer)this.objectSerializer));
            return 1;
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public int updateParticipant(HmilyTransaction hmilyTransaction) {
        try {
            String redisKey = RepositoryPathUtils.buildRedisKey((String)this.keyPrefix, (String)hmilyTransaction.getTransId());
            byte[] contents = this.jedisClient.get(redisKey.getBytes());
            CoordinatorRepositoryAdapter adapter = (CoordinatorRepositoryAdapter)this.objectSerializer.deSerialize(contents, CoordinatorRepositoryAdapter.class);
            adapter.setContents(this.objectSerializer.serialize((Object)hmilyTransaction.getHmilyParticipants()));
            this.jedisClient.set(redisKey, this.objectSerializer.serialize((Object)adapter));
        }
        catch (HmilyException e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    @Override
    public int updateStatus(String id, Integer status) {
        try {
            String redisKey = RepositoryPathUtils.buildRedisKey((String)this.keyPrefix, (String)id);
            byte[] contents = this.jedisClient.get(redisKey.getBytes());
            if (contents != null) {
                CoordinatorRepositoryAdapter adapter = (CoordinatorRepositoryAdapter)this.objectSerializer.deSerialize(contents, CoordinatorRepositoryAdapter.class);
                adapter.setStatus(status.intValue());
                this.jedisClient.set(redisKey, this.objectSerializer.serialize((Object)adapter));
            }
        }
        catch (HmilyException e) {
            e.printStackTrace();
            return 0;
        }
        return 1;
    }

    @Override
    public HmilyTransaction findById(String id) {
        try {
            String redisKey = RepositoryPathUtils.buildRedisKey((String)this.keyPrefix, (String)id);
            byte[] contents = this.jedisClient.get(redisKey.getBytes());
            return RepositoryConvertUtils.transformBean((byte[])contents, (ObjectSerializer)this.objectSerializer);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<HmilyTransaction> listAll() {
        try {
            ArrayList transactions = Lists.newArrayList();
            Set keys = this.jedisClient.keys((this.keyPrefix + "*").getBytes());
            for (byte[] key : keys) {
                byte[] contents = this.jedisClient.get(key);
                if (contents == null) continue;
                transactions.add(RepositoryConvertUtils.transformBean((byte[])contents, (ObjectSerializer)this.objectSerializer));
            }
            return transactions;
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<HmilyTransaction> listAllByDelay(Date date) {
        List<HmilyTransaction> hmilyTransactions = this.listAll();
        return hmilyTransactions.stream().filter(tccTransaction -> tccTransaction.getLastTime().compareTo(date) < 0).collect(Collectors.toList());
    }

    @Override
    public void init(String modelName, HmilyConfig hmilyConfig) {
        this.keyPrefix = RepositoryPathUtils.buildRedisKeyPrefix((String)modelName);
        HmilyRedisConfig hmilyRedisConfig = hmilyConfig.getHmilyRedisConfig();
        try {
            this.buildJedisPool(hmilyRedisConfig);
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOGGER, (String)"redis init error please check you config:{}", e::getMessage);
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getScheme() {
        return RepositorySupportEnum.REDIS.getSupport();
    }

    @Override
    public void setSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    private void buildJedisPool(HmilyRedisConfig hmilyRedisConfig) {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(hmilyRedisConfig.getMaxIdle());
        config.setMinIdle(hmilyRedisConfig.getMinIdle());
        config.setMaxTotal(hmilyRedisConfig.getMaxTotal());
        config.setMaxWaitMillis(hmilyRedisConfig.getMaxWaitMillis());
        config.setTestOnBorrow(hmilyRedisConfig.getTestOnBorrow().booleanValue());
        config.setTestOnReturn(hmilyRedisConfig.getTestOnReturn().booleanValue());
        config.setTestWhileIdle(hmilyRedisConfig.getTestWhileIdle().booleanValue());
        config.setMinEvictableIdleTimeMillis(hmilyRedisConfig.getMinEvictableIdleTimeMillis());
        config.setSoftMinEvictableIdleTimeMillis(hmilyRedisConfig.getSoftMinEvictableIdleTimeMillis());
        config.setTimeBetweenEvictionRunsMillis(hmilyRedisConfig.getTimeBetweenEvictionRunsMillis());
        config.setNumTestsPerEvictionRun(hmilyRedisConfig.getNumTestsPerEvictionRun());
        if (hmilyRedisConfig.getCluster().booleanValue()) {
            LogUtil.info((Logger)LOGGER, () -> "build redis cluster ............");
            String clusterUrl = hmilyRedisConfig.getClusterUrl();
            Set hostAndPorts = Splitter.on((String)";").splitToList((CharSequence)clusterUrl).stream().map(HostAndPort::parseString).collect(Collectors.toSet());
            JedisCluster jedisCluster = new JedisCluster(hostAndPorts, (GenericObjectPoolConfig)config);
            this.jedisClient = new JedisClientCluster(jedisCluster);
        } else if (hmilyRedisConfig.getSentinel().booleanValue()) {
            LogUtil.info((Logger)LOGGER, () -> "build redis sentinel ............");
            String sentinelUrl = hmilyRedisConfig.getSentinelUrl();
            HashSet hostAndPorts = new HashSet(Splitter.on((String)";").splitToList((CharSequence)sentinelUrl));
            JedisSentinelPool pool = new JedisSentinelPool(hmilyRedisConfig.getMasterName(), hostAndPorts, (GenericObjectPoolConfig)config, hmilyRedisConfig.getTimeOut(), hmilyRedisConfig.getPassword());
            this.jedisClient = new JedisClientSentinel(pool);
        } else {
            JedisPool jedisPool = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{hmilyRedisConfig.getPassword()}) ? new JedisPool((GenericObjectPoolConfig)config, hmilyRedisConfig.getHostName(), hmilyRedisConfig.getPort(), hmilyRedisConfig.getTimeOut(), hmilyRedisConfig.getPassword()) : new JedisPool((GenericObjectPoolConfig)config, hmilyRedisConfig.getHostName(), hmilyRedisConfig.getPort(), hmilyRedisConfig.getTimeOut());
            this.jedisClient = new JedisClientSingle(jedisPool);
        }
    }
}

