/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hmily.core.spi.repository;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.dromara.hmily.annotation.HmilySPI;
import org.dromara.hmily.common.bean.adapter.CoordinatorRepositoryAdapter;
import org.dromara.hmily.common.bean.entity.HmilyTransaction;
import org.dromara.hmily.common.config.HmilyConfig;
import org.dromara.hmily.common.config.HmilyZookeeperConfig;
import org.dromara.hmily.common.enums.RepositorySupportEnum;
import org.dromara.hmily.common.exception.HmilyException;
import org.dromara.hmily.common.exception.HmilyRuntimeException;
import org.dromara.hmily.common.serializer.ObjectSerializer;
import org.dromara.hmily.common.utils.CollectionUtils;
import org.dromara.hmily.common.utils.LogUtil;
import org.dromara.hmily.common.utils.RepositoryConvertUtils;
import org.dromara.hmily.common.utils.RepositoryPathUtils;
import org.dromara.hmily.common.utils.StringUtils;
import org.dromara.hmily.core.spi.HmilyCoordinatorRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HmilySPI(value="zookeeper")
public class ZookeeperCoordinatorRepository
implements HmilyCoordinatorRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperCoordinatorRepository.class);
    private static volatile ZooKeeper zooKeeper;
    private static final CountDownLatch LATCH;
    private ObjectSerializer objectSerializer;
    private String rootPathPrefix = "/hmily";

    @Override
    public int create(HmilyTransaction hmilyTransaction) {
        try {
            zooKeeper.create(this.buildRootPath(hmilyTransaction.getTransId()), RepositoryConvertUtils.convert((HmilyTransaction)hmilyTransaction, (ObjectSerializer)this.objectSerializer), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            return 1;
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public int remove(String id) {
        try {
            zooKeeper.delete(this.buildRootPath(id), -1);
            return 1;
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public int update(HmilyTransaction hmilyTransaction) throws HmilyRuntimeException {
        try {
            hmilyTransaction.setLastTime(new Date());
            hmilyTransaction.setVersion(Integer.valueOf(hmilyTransaction.getVersion() + 1));
            zooKeeper.setData(this.buildRootPath(hmilyTransaction.getTransId()), RepositoryConvertUtils.convert((HmilyTransaction)hmilyTransaction, (ObjectSerializer)this.objectSerializer), -1);
            return 1;
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public int updateParticipant(HmilyTransaction hmilyTransaction) {
        String path = RepositoryPathUtils.buildZookeeperRootPath((String)this.rootPathPrefix, (String)hmilyTransaction.getTransId());
        try {
            byte[] content = zooKeeper.getData(path, false, new Stat());
            if (content != null) {
                CoordinatorRepositoryAdapter adapter = (CoordinatorRepositoryAdapter)this.objectSerializer.deSerialize(content, CoordinatorRepositoryAdapter.class);
                adapter.setContents(this.objectSerializer.serialize((Object)hmilyTransaction.getHmilyParticipants()));
                zooKeeper.setData(path, this.objectSerializer.serialize((Object)adapter), -1);
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int updateStatus(String id, Integer status) {
        String path = RepositoryPathUtils.buildZookeeperRootPath((String)this.rootPathPrefix, (String)id);
        try {
            byte[] content = zooKeeper.getData(path, false, new Stat());
            if (content != null) {
                CoordinatorRepositoryAdapter adapter = (CoordinatorRepositoryAdapter)this.objectSerializer.deSerialize(content, CoordinatorRepositoryAdapter.class);
                adapter.setStatus(status.intValue());
                zooKeeper.setData(path, this.objectSerializer.serialize((Object)adapter), -1);
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public HmilyTransaction findById(String id) {
        try {
            Stat stat = new Stat();
            byte[] content = zooKeeper.getData(this.buildRootPath(id), false, stat);
            return RepositoryConvertUtils.transformBean((byte[])content, (ObjectSerializer)this.objectSerializer);
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<HmilyTransaction> listAll() {
        List zNodePaths;
        List<Object> transactionRecovers = Lists.newArrayList();
        try {
            zNodePaths = zooKeeper.getChildren(this.rootPathPrefix, false);
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
        if (CollectionUtils.isNotEmpty((Collection)zNodePaths)) {
            transactionRecovers = zNodePaths.stream().filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(zNodePath -> {
                try {
                    byte[] content = zooKeeper.getData(this.buildRootPath((String)zNodePath), false, new Stat());
                    return RepositoryConvertUtils.transformBean((byte[])content, (ObjectSerializer)this.objectSerializer);
                }
                catch (InterruptedException | KeeperException | HmilyException e) {
                    e.printStackTrace();
                    return null;
                }
            }).collect(Collectors.toList());
        }
        return transactionRecovers;
    }

    @Override
    public List<HmilyTransaction> listAllByDelay(Date date) {
        List<HmilyTransaction> hmilyTransactions = this.listAll();
        return hmilyTransactions.stream().filter(transaction -> transaction.getLastTime().compareTo(date) > 0).collect(Collectors.toList());
    }

    @Override
    public void init(String modelName, HmilyConfig hmilyConfig) {
        this.rootPathPrefix = RepositoryPathUtils.buildZookeeperPathPrefix((String)modelName);
        try {
            this.connect(hmilyConfig.getHmilyZookeeperConfig());
        }
        catch (Exception e) {
            LogUtil.error((Logger)LOGGER, (String)"zookeeper init error please check you config:{}", e::getMessage);
            throw new HmilyRuntimeException(e.getMessage());
        }
    }

    private void connect(HmilyZookeeperConfig config) {
        try {
            zooKeeper = new ZooKeeper(config.getHost(), config.getSessionTimeOut(), watchedEvent -> {
                if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                    LATCH.countDown();
                }
            });
            LATCH.await();
            Stat stat = zooKeeper.exists(this.rootPathPrefix, false);
            if (stat == null) {
                zooKeeper.create(this.rootPathPrefix, this.rootPathPrefix.getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
        catch (Exception e) {
            throw new HmilyRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getScheme() {
        return RepositorySupportEnum.ZOOKEEPER.getSupport();
    }

    @Override
    public void setSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }

    private String buildRootPath(String id) {
        return RepositoryPathUtils.buildZookeeperRootPath((String)this.rootPathPrefix, (String)id);
    }

    static {
        LATCH = new CountDownLatch(1);
    }
}

