/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection.iter;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.dromara.hutool.core.collection.iter.ComputeIter;
import org.dromara.hutool.core.collection.iter.IterableIter;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;

public class LineIter
extends ComputeIter<String>
implements IterableIter<String>,
Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BufferedReader bufferedReader;

    public LineIter(InputStream in, Charset charset) throws IllegalArgumentException {
        this(IoUtil.toReader(in, charset));
    }

    public LineIter(Reader reader) throws IllegalArgumentException {
        Assert.notNull(reader, "Reader must not be null", new Object[0]);
        this.bufferedReader = IoUtil.toBuffered(reader);
    }

    @Override
    protected String computeNext() {
        try {
            String line;
            do {
                if ((line = this.bufferedReader.readLine()) != null) continue;
                return null;
            } while (!this.isValidLine(line));
            return line;
        }
        catch (IOException ioe) {
            this.close();
            throw new IORuntimeException(ioe);
        }
    }

    @Override
    public void close() {
        super.finish();
        IoUtil.closeQuietly(this.bufferedReader);
    }

    protected boolean isValidLine(String line) {
        return true;
    }
}

