/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert.impl;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.copier.BeanCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.bean.copier.ValueProvider;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.io.SerializeUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapProxy;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class BeanConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    public static BeanConverter INSTANCE = new BeanConverter();
    private final CopyOptions copyOptions;

    public BeanConverter() {
        this(CopyOptions.of().setIgnoreError(true));
    }

    public BeanConverter(CopyOptions copyOptions) {
        this.copyOptions = copyOptions;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Assert.notNull(targetType);
        if (null == value) {
            return null;
        }
        if (value instanceof Converter) {
            return ((Converter)value).convert(targetType, value);
        }
        Class<?> targetClass = TypeUtil.getClass(targetType);
        Assert.notNull(targetClass, "Target type is not a class!", new Object[0]);
        return this.convertInternal(targetType, targetClass, value);
    }

    private Object convertInternal(Type targetType, Class<?> targetClass, Object value) {
        if (value instanceof Map || value instanceof ValueProvider || BeanUtil.isWritableBean(value.getClass())) {
            if (value instanceof Map && targetClass.isInterface()) {
                return MapProxy.of((Map)value).toProxyBean(targetClass);
            }
            return BeanCopier.of(value, ConstructorUtil.newInstanceIfPossible(targetClass), targetType, this.copyOptions).copy();
        }
        if (value instanceof byte[]) {
            return SerializeUtil.deserialize((byte[])value, new Class[0]);
        }
        if (StrUtil.isEmptyIfStr(value)) {
            return null;
        }
        throw new ConvertException("Unsupported source type: [{}] to [{}]", value.getClass(), targetType);
    }
}

