/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;

public class CharsetDetector {
    private static final Charset[] DEFAULT_CHARSETS;

    public static Charset detect(File file, Charset ... charsets) {
        return CharsetDetector.detect(FileUtil.getInputStream(file), charsets);
    }

    public static Charset detect(InputStream in, Charset ... charsets) {
        return CharsetDetector.detect(8192, in, charsets);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Charset detect(int bufferSize, InputStream in, Charset ... charsets) {
        Charset charset;
        block10: {
            if (ArrayUtil.isEmpty(charsets)) {
                charsets = DEFAULT_CHARSETS;
            }
            byte[] buffer = new byte[bufferSize];
            try {
                block5: while (true) {
                    if (in.read(buffer) <= -1) {
                        IoUtil.closeQuietly(in);
                        return null;
                    }
                    Charset[] charsetArray = charsets;
                    int n = charsetArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block5;
                        Charset charset2 = charsetArray[n2];
                        CharsetDecoder decoder = charset2.newDecoder();
                        if (CharsetDetector.identify(buffer, decoder)) {
                            charset = charset2;
                            break block10;
                        }
                        ++n2;
                    }
                    break;
                }
            }
            catch (IOException e) {
                try {
                    throw new IORuntimeException(e);
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly(in);
                    throw throwable;
                }
            }
        }
        IoUtil.closeQuietly(in);
        return charset;
    }

    private static boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    static {
        String[] names = new String[]{"UTF-8", "GBK", "GB2312", "GB18030", "UTF-16BE", "UTF-16LE", "UTF-16", "BIG5", "UNICODE", "US-ASCII"};
        DEFAULT_CHARSETS = Convert.convert(Charset[].class, (Object)names);
    }
}

