/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.watch.watchers;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Set;
import org.dromara.hutool.core.collection.ConcurrentHashSet;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.thread.ThreadUtil;

public class DelayWatcher
implements Watcher {
    private final Set<Path> eventSet = new ConcurrentHashSet<Path>();
    private final Watcher watcher;
    private final long delay;

    public DelayWatcher(Watcher watcher, long delay) {
        Assert.notNull(watcher);
        if (watcher instanceof DelayWatcher) {
            throw new IllegalArgumentException("Watcher must not be a DelayWatcher");
        }
        this.watcher = watcher;
        this.delay = delay;
    }

    @Override
    public void onModify(WatchEvent<?> event, WatchKey key) {
        if (this.delay < 1L) {
            this.watcher.onModify(event, key);
        } else {
            this.onDelayModify(event, key);
        }
    }

    @Override
    public void onCreate(WatchEvent<?> event, WatchKey key) {
        this.watcher.onCreate(event, key);
    }

    @Override
    public void onDelete(WatchEvent<?> event, WatchKey key) {
        this.watcher.onDelete(event, key);
    }

    @Override
    public void onOverflow(WatchEvent<?> event, WatchKey key) {
        this.watcher.onOverflow(event, key);
    }

    private void onDelayModify(WatchEvent<?> event, WatchKey key) {
        Path eventPath = Paths.get(key.watchable().toString(), event.context().toString());
        if (this.eventSet.contains(eventPath)) {
            return;
        }
        this.eventSet.add(eventPath);
        this.startHandleModifyThread(event, key);
    }

    private void startHandleModifyThread(WatchEvent<?> event, WatchKey key) {
        ThreadUtil.execute(() -> {
            ThreadUtil.sleep(this.delay);
            this.eventSet.remove(Paths.get(key.watchable().toString(), event.context().toString()));
            this.watcher.onModify(event, key);
        });
    }
}

