/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.map.multi.ListValueMap;
import org.dromara.hutool.core.map.multi.MultiValueMap;
import org.dromara.hutool.core.net.multipart.MultipartRequestInputStream;
import org.dromara.hutool.core.net.multipart.UploadFile;
import org.dromara.hutool.core.net.multipart.UploadFileHeader;
import org.dromara.hutool.core.net.multipart.UploadSetting;

public class MultipartFormData {
    private final MultiValueMap<String, String> requestParameters = new ListValueMap<String, String>();
    private final MultiValueMap<String, UploadFile> requestFiles = new ListValueMap<String, UploadFile>();
    private final UploadSetting setting;
    private boolean loaded;

    public MultipartFormData() {
        this(null);
    }

    public MultipartFormData(UploadSetting uploadSetting) {
        this.setting = uploadSetting == null ? new UploadSetting() : uploadSetting;
    }

    public void parseRequestStream(InputStream inputStream, Charset charset) throws IOException {
        UploadFileHeader header;
        this.setLoaded();
        MultipartRequestInputStream input = new MultipartRequestInputStream(inputStream);
        input.readBoundary();
        while ((header = input.readDataHeader(charset)) != null) {
            if (header.isFile) {
                UploadFile newFile;
                String fileName = header.fileName;
                if (!fileName.isEmpty() && header.contentType.contains("application/x-macbinary")) {
                    input.skipBytes(128L);
                }
                if ((newFile = new UploadFile(header, this.setting)).processStream(input)) {
                    this.putFile(header.formFieldName, newFile);
                }
            } else {
                this.putParameter(header.formFieldName, input.readString(charset));
            }
            input.skipBytes(1L);
            input.mark(1);
            int nextByte = input.read();
            if (nextByte == -1 || nextByte == 45) {
                input.reset();
                break;
            }
            input.reset();
        }
    }

    public String getParam(String paramName) {
        Collection<String> values = this.getListParam(paramName);
        if (CollUtil.isNotEmpty(values)) {
            return CollUtil.get(values, 0);
        }
        return null;
    }

    public Set<String> getParamNames() {
        return this.requestParameters.keySet();
    }

    public String[] getArrayParam(String paramName) {
        Collection<String> listParam = this.getListParam(paramName);
        if (null != listParam) {
            return listParam.toArray(new String[0]);
        }
        return null;
    }

    public Collection<String> getListParam(String paramName) {
        return (Collection)this.requestParameters.get(paramName);
    }

    public Map<String, String[]> getParamMap() {
        return Convert.toMap(String.class, String[].class, this.getParamListMap());
    }

    public MultiValueMap<String, String> getParamListMap() {
        return this.requestParameters;
    }

    public UploadFile getFile(String paramName) {
        UploadFile[] values = this.getFiles(paramName);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public UploadFile[] getFiles(String paramName) {
        Collection<UploadFile> fileList = this.getFileList(paramName);
        if (null != fileList) {
            return fileList.toArray(new UploadFile[0]);
        }
        return null;
    }

    public Collection<UploadFile> getFileList(String paramName) {
        return (Collection)this.requestFiles.get(paramName);
    }

    public Set<String> getFileParamNames() {
        return this.requestFiles.keySet();
    }

    public Map<String, UploadFile[]> getFileMap() {
        return Convert.toMap(String.class, UploadFile[].class, this.getFileListValueMap());
    }

    public MultiValueMap<String, UploadFile> getFileListValueMap() {
        return this.requestFiles;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void putFile(String name, UploadFile uploadFile) {
        this.requestFiles.putValue(name, uploadFile);
    }

    private void putParameter(String name, String value) {
        this.requestParameters.putValue(name, value);
    }

    private void setLoaded() throws IOException {
        if (this.loaded) {
            throw new IOException("Multi-part request already parsed.");
        }
        this.loaded = true;
    }
}

