/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.lookup;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.reflect.lookup.LookupFactory;

public class MethodLookupFactory
implements LookupFactory {
    private final Method privateLookupInMethod = MethodLookupFactory.createJdk9PrivateLookupInMethod();

    @Override
    public MethodHandles.Lookup lookup(Class<?> callerClass) {
        try {
            return (MethodHandles.Lookup)this.privateLookupInMethod.invoke(MethodHandles.class, callerClass, MethodHandles.lookup());
        }
        catch (IllegalAccessException e) {
            throw new HutoolException(e);
        }
        catch (InvocationTargetException e) {
            throw new HutoolException(e.getTargetException());
        }
    }

    private static Method createJdk9PrivateLookupInMethod() {
        try {
            return MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("There is no 'privateLookupIn(Class, Lookup)' method in java.lang.invoke.MethodHandles.", e);
        }
    }
}

