/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.stream;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.stream.AbstractEnhancedWrappedStream;
import org.dromara.hutool.core.stream.StreamUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class EasyStream<T>
extends AbstractEnhancedWrappedStream<T, EasyStream<T>> {
    EasyStream(Stream<T> stream) {
        super(ObjUtil.isNull(stream) ? Stream.empty() : stream);
    }

    public static <T> Builder<T> builder() {
        return new Builder<T>(){
            private static final long serialVersionUID = 1L;
            private final Stream.Builder<T> streamBuilder = Stream.builder();

            @Override
            public void accept(T t) {
                this.streamBuilder.accept(t);
            }

            @Override
            public EasyStream<T> build() {
                return new EasyStream(this.streamBuilder.build());
            }
        };
    }

    public static <T> EasyStream<T> empty() {
        return new EasyStream(Stream.empty());
    }

    public static <T> EasyStream<T> of(T t) {
        return new EasyStream<T>(Stream.of(t));
    }

    @SafeVarargs
    public static <T> EasyStream<T> of(T ... values) {
        return ArrayUtil.isEmpty(values) ? EasyStream.empty() : new EasyStream<T>(Stream.of(values));
    }

    public static <T> EasyStream<T> of(Iterable<T> iterable) {
        return EasyStream.of(iterable, false);
    }

    public static <T> EasyStream<T> of(Iterable<T> iterable, boolean parallel) {
        return Opt.ofNullable(iterable).map(Iterable::spliterator).map((? super T spliterator) -> StreamSupport.stream(spliterator, parallel)).map(EasyStream::new).orElseGet(EasyStream::empty);
    }

    public static <T> EasyStream<T> of(Stream<T> stream) {
        return new EasyStream<T>(stream);
    }

    public static <T> EasyStream<T> iterate(T seed, UnaryOperator<T> f) {
        return new EasyStream<T>(Stream.iterate(seed, f));
    }

    public static <T> EasyStream<T> iterate(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        Objects.requireNonNull(next);
        Objects.requireNonNull(hasNext);
        return new EasyStream<T>(StreamUtil.iterate(seed, hasNext, next));
    }

    public static <T> EasyStream<T> iterateHierarchies(T root, Function<T, Collection<T>> discoverer, Predicate<T> filter) {
        return EasyStream.of(StreamUtil.iterateHierarchies(root, discoverer, filter));
    }

    public static <T> EasyStream<T> iterateHierarchies(T root, Function<T, Collection<T>> discoverer) {
        return EasyStream.of(StreamUtil.iterateHierarchies(root, discoverer));
    }

    public static <T> EasyStream<T> generate(Supplier<T> s) {
        return new EasyStream<T>(Stream.generate(s));
    }

    public static <T> EasyStream<T> concat(Stream<? extends T> a, Stream<? extends T> b) {
        return new EasyStream<T>(Stream.concat(a, b));
    }

    public static EasyStream<String> split(CharSequence str, String regex) {
        return Opt.ofBlankAble(str).map(CharSequence::toString).map((? super T s) -> s.split(regex)).map(EasyStream::of).orElseGet(EasyStream::empty);
    }

    @Override
    public <R> EasyStream<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return new EasyStream<R>(this.stream.map(mapper));
    }

    @Override
    public EasyStream<T> wrap(Stream<T> stream) {
        return new EasyStream<T>(stream);
    }

    public int sum(ToIntFunction<? super T> mapper) {
        return this.stream.mapToInt(mapper).sum();
    }

    public long sum(ToLongFunction<? super T> mapper) {
        return this.stream.mapToLong(mapper).sum();
    }

    public double sum(ToDoubleFunction<? super T> mapper) {
        return this.stream.mapToDouble(mapper).sum();
    }

    public <R extends Number> BigDecimal sum(Function<? super T, R> mapper) {
        return this.stream.map(mapper).reduce(BigDecimal.ZERO, (xva$0, xva$1) -> NumberUtil.add(xva$0, xva$1), (xva$0, xva$1) -> NumberUtil.add(xva$0, xva$1));
    }

    public Opt<BigDecimal> avg(Function<? super T, BigDecimal> mapper) {
        return this.avg(mapper, 2);
    }

    public Opt<BigDecimal> avg(Function<? super T, BigDecimal> mapper, int scale) {
        return this.avg(mapper, scale, RoundingMode.HALF_UP);
    }

    public Opt<BigDecimal> avg(Function<? super T, BigDecimal> mapper, int scale, RoundingMode roundingMode) {
        List bigDecimalList = this.stream.map(mapper).collect(Collectors.toList());
        if (CollUtil.isEmpty(bigDecimalList)) {
            return Opt.empty();
        }
        return Opt.ofNullable(EasyStream.of(bigDecimalList).reduce(BigDecimal.ZERO, BigDecimal::add).divide(NumberUtil.toBigDecimal(bigDecimalList.size()), scale, roundingMode));
    }

    public OptionalDouble avg(ToIntFunction<? super T> mapper) {
        return this.stream.mapToInt(mapper).average();
    }

    public OptionalDouble avg(ToDoubleFunction<? super T> mapper) {
        return this.stream.mapToDouble(mapper).average();
    }

    public OptionalDouble avg(ToLongFunction<? super T> mapper) {
        return this.stream.mapToLong(mapper).average();
    }

    public static interface Builder<T>
    extends Consumer<T>,
    org.dromara.hutool.core.lang.builder.Builder<EasyStream<T>> {
        default public Builder<T> add(T t) {
            this.accept(t);
            return this;
        }
    }
}

