/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.stream.spliterators;

import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class IterateSpliterator<T>
extends Spliterators.AbstractSpliterator<T> {
    private final T seed;
    private final Predicate<? super T> hasNext;
    private final UnaryOperator<T> next;
    private T prev;
    private boolean started;
    private boolean finished;

    IterateSpliterator(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        super(Long.MAX_VALUE, 1040);
        this.seed = seed;
        this.hasNext = hasNext;
        this.next = next;
    }

    public static <T> IterateSpliterator<T> create(T seed, Predicate<? super T> hasNext, UnaryOperator<T> next) {
        return new IterateSpliterator<T>(seed, hasNext, next);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        Object t;
        Objects.requireNonNull(action);
        if (this.finished) {
            return false;
        }
        if (this.started) {
            t = this.next.apply(this.prev);
        } else {
            t = this.seed;
            this.started = true;
        }
        if (!this.hasNext.test(t)) {
            this.prev = null;
            this.finished = true;
            return false;
        }
        this.prev = t;
        action.accept(this.prev);
        return true;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (this.finished) {
            return;
        }
        this.finished = true;
        Object t = this.started ? this.next.apply(this.prev) : this.seed;
        this.prev = null;
        while (this.hasNext.test(t)) {
            action.accept(t);
            t = this.next.apply(t);
        }
    }
}

