/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.text.replacer;

import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.replacer.StrReplacer;

public class RangeReplacerByStr
extends StrReplacer {
    private static final long serialVersionUID = 1L;
    private final int beginInclude;
    private final int endExclude;
    private final CharSequence replacedStr;

    public RangeReplacerByStr(int beginInclude, int endExclude, CharSequence replacedStr) {
        this.beginInclude = beginInclude;
        this.endExclude = endExclude;
        this.replacedStr = replacedStr;
    }

    @Override
    public String apply(CharSequence str) {
        int i;
        if (StrUtil.isEmpty(str)) {
            return StrUtil.str(str);
        }
        int beginInclude = this.beginInclude;
        String originalStr = StrUtil.str(str);
        int[] strCodePoints = originalStr.codePoints().toArray();
        int strLength = strCodePoints.length;
        if (beginInclude > strLength) {
            return originalStr;
        }
        int endExclude = this.endExclude;
        if (endExclude > strLength) {
            endExclude = strLength;
        }
        if (beginInclude > endExclude) {
            return originalStr;
        }
        StringBuilder stringBuilder = new StringBuilder(originalStr.length() - (endExclude - beginInclude) + this.replacedStr.length());
        for (i = 0; i < beginInclude; ++i) {
            stringBuilder.appendCodePoint(strCodePoints[i]);
        }
        this.replace(originalStr, beginInclude, stringBuilder);
        for (i = endExclude; i < strLength; ++i) {
            stringBuilder.appendCodePoint(strCodePoints[i]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected int replace(CharSequence str, int pos, StringBuilder out) {
        out.append(this.replacedStr);
        return this.endExclude;
    }
}

