/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.Query;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.StatementUtil;

public class AnsiSqlDialect
implements Dialect {
    private static final long serialVersionUID = 2088101129774974580L;
    protected DbConfig dbConfig;
    protected QuoteWrapper quoteWrapper = new QuoteWrapper();

    public AnsiSqlDialect(DbConfig dbConfig) {
        this.dbConfig = dbConfig;
    }

    @Override
    public QuoteWrapper getWrapper() {
        return this.quoteWrapper;
    }

    @Override
    public void setWrapper(QuoteWrapper quoteWrapper) {
        this.quoteWrapper = quoteWrapper;
    }

    @Override
    public PreparedStatement psForInsert(boolean returnGeneratedKey, Connection conn, Entity entity) {
        SqlBuilder insert = SqlBuilder.of(this.quoteWrapper).insert(entity, this.dialectName());
        return StatementUtil.prepareStatement(returnGeneratedKey, this.dbConfig, conn, insert.build(), insert.getParamValueArray());
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, Entity ... entities) {
        if (ArrayUtil.isEmpty(entities)) {
            throw new DbException("Entities for batch insert is empty !");
        }
        SqlBuilder insert = SqlBuilder.of(this.quoteWrapper).insert(entities[0], this.dialectName());
        return StatementUtil.prepareStatementForBatch(this.dbConfig, conn, insert.build(), new Object[][]{entities});
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Query query) throws DbException {
        Assert.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new DbException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.of(this.quoteWrapper).delete(query.getFirstTableName()).where(where);
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, delete.build(), delete.getParamValueArray());
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Query query) throws DbException {
        Assert.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new DbException("No 'WHERE' condition, we can't prepare statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.of(this.quoteWrapper).update(entity).where(where);
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, update.build(), update.getParamValueArray());
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Query query) {
        return this.psForPage(conn, query);
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) {
        Assert.notNull(query, "query must be not null !", new Object[0]);
        if (ArrayUtil.hasBlank(query.getTableNames())) {
            throw new DbException("Table name must be not empty !");
        }
        SqlBuilder find = SqlBuilder.of(this.quoteWrapper).query(query);
        return this.psForPage(conn, find, query.getPage());
    }

    @Override
    public PreparedStatement psForPage(Connection conn, SqlBuilder sqlBuilder, Page page) {
        if (null != page) {
            sqlBuilder = this.wrapPageSql(sqlBuilder.orderBy(page.getOrders()), page);
        }
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, sqlBuilder.build(), sqlBuilder.getParamValueArray());
    }

    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getPageSize()).append(" offset ").append(page.getStartPosition());
    }

    @Override
    public String dialectName() {
        return DialectName.ANSI.name();
    }
}

