/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.StatementUtil;

public class H2Dialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 1490520247974768214L;

    public H2Dialect(DbConfig config) {
        super(config);
    }

    @Override
    public String dialectName() {
        return DialectName.H2.name();
    }

    @Override
    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getStartPosition()).append(" , ").append(page.getPageSize());
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) {
        Assert.notEmpty(keys, "Keys must be not empty for H2 MERGE SQL.", new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.of(this.quoteWrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank(field)) {
                if (fieldsPart.length() > 0) {
                    fieldsPart.append(", ");
                    placeHolder.append(", ");
                }
                fieldsPart.append(null != this.quoteWrapper ? this.quoteWrapper.wrap((String)field) : field);
                placeHolder.append("?");
                builder.addParams(value);
            }
        });
        String tableName = entity.getTableName();
        if (null != this.quoteWrapper) {
            tableName = this.quoteWrapper.wrap(tableName);
            keys = this.quoteWrapper.wrap(keys);
        }
        builder.append("MERGE INTO ").append(tableName).append(" (").append(fieldsPart).append(") KEY(").append(ArrayUtil.join(keys, (CharSequence)", ")).append(") VALUES (").append(placeHolder).append(")");
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, builder.build(), builder.getParamValueArray());
    }
}

