/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.StatementUtil;

public class MysqlDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = -3734718212043823636L;

    public MysqlDialect(DbConfig dbConfig) {
        super(dbConfig);
        this.quoteWrapper = new QuoteWrapper(Character.valueOf('`'));
    }

    @Override
    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" LIMIT ").append(page.getStartPosition()).append(", ").append(page.getPageSize());
    }

    @Override
    public String dialectName() {
        return DialectName.MYSQL.toString();
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) {
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.of(this.quoteWrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        StringBuilder updateHolder = new StringBuilder();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank(field)) {
                if (fieldsPart.length() > 0) {
                    fieldsPart.append(", ");
                    placeHolder.append(", ");
                    updateHolder.append(", ");
                }
                field = null != this.quoteWrapper ? this.quoteWrapper.wrap((String)field) : field;
                fieldsPart.append((String)field);
                updateHolder.append((String)field).append("=values(").append((String)field).append(")");
                placeHolder.append("?");
                builder.addParams(value);
            }
        });
        String tableName = entity.getTableName();
        if (null != this.quoteWrapper) {
            tableName = this.quoteWrapper.wrap(tableName);
        }
        builder.append("INSERT INTO ").append(tableName).append(" (").append(fieldsPart).append(") VALUES (").append(placeHolder).append(") ON DUPLICATE KEY UPDATE ").append(updateHolder);
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, builder.build(), builder.getParamValueArray());
    }
}

