/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.sshj;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Parameters;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.forwarded.ConnectListener;
import net.schmizz.sshj.connection.channel.forwarded.RemotePortForwarder;
import net.schmizz.sshj.connection.channel.forwarded.SocketForwardingConnectListener;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.Session;
import org.dromara.hutool.extra.ssh.engine.sshj.SshjSftp;
import org.dromara.hutool.extra.ssh.engine.sshj.SshjUtil;

public class SshjSession
implements Session {
    private final SSHClient ssh;
    private final net.schmizz.sshj.connection.channel.direct.Session raw;
    private Map<String, ServerSocket> localPortForwarderMap;

    public SshjSession(Connector connector) {
        this(SshjUtil.openClient(connector));
    }

    public SshjSession(SSHClient ssh) {
        this.ssh = ssh;
        try {
            this.raw = ssh.startSession();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public net.schmizz.sshj.connection.channel.direct.Session getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return null != this.raw && (null == this.ssh || this.ssh.isConnected());
    }

    @Override
    public void close() throws IOException {
        IoUtil.closeQuietly(new AutoCloseable[]{this.raw});
        IoUtil.closeQuietly(new AutoCloseable[]{this.ssh});
    }

    public SshjSftp openSftp(Charset charset) {
        return new SshjSftp(this.ssh, charset);
    }

    @Override
    public void bindLocalPort(InetSocketAddress localAddress, InetSocketAddress remoteAddress) throws IORuntimeException {
        ServerSocket ss;
        Parameters params = new Parameters(localAddress.getHostName(), localAddress.getPort(), remoteAddress.getHostName(), remoteAddress.getPort());
        try {
            ss = new ServerSocket();
            ss.setReuseAddress(true);
            ss.bind(localAddress);
            this.ssh.newLocalPortForwarder(params, ss).listen();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == this.localPortForwarderMap) {
            this.localPortForwarderMap = new HashMap<String, ServerSocket>();
        }
        this.localPortForwarderMap.put(localAddress.toString(), ss);
    }

    @Override
    public void unBindLocalPort(InetSocketAddress localAddress) throws IORuntimeException {
        if (MapUtil.isEmpty(this.localPortForwarderMap)) {
            return;
        }
        IoUtil.closeQuietly(this.localPortForwarderMap.remove(localAddress.toString()));
    }

    @Override
    public void bindRemotePort(InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws IORuntimeException {
        try {
            this.ssh.getRemotePortForwarder().bind(new RemotePortForwarder.Forward(remoteAddress.getHostName(), remoteAddress.getPort()), (ConnectListener)new SocketForwardingConnectListener((SocketAddress)localAddress));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void unBindRemotePort(InetSocketAddress remoteAddress) {
        String hostName = remoteAddress.getHostName();
        int port = remoteAddress.getPort();
        RemotePortForwarder remotePortForwarder = this.ssh.getRemotePortForwarder();
        Set activeForwards = remotePortForwarder.getActiveForwards();
        for (RemotePortForwarder.Forward activeForward : activeForwards) {
            String activeAddress;
            if (port != activeForward.getPort() || StrUtil.isNotBlank(activeAddress = activeForward.getAddress()) && !StrUtil.equalsIgnoreCase(hostName, activeAddress)) continue;
            try {
                remotePortForwarder.cancel(activeForward);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            return;
        }
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        Session.Command command;
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            command = this.raw.exec(cmd);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != errStream) {
            IoUtil.copy(command.getErrorStream(), errStream);
        }
        return IoUtil.read(command.getInputStream(), charset);
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        Session.Shell shell;
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            shell = this.raw.startShell();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        IoUtil.write(shell.getOutputStream(), charset, true, cmd);
        if (null != errStream) {
            IoUtil.copy(shell.getErrorStream(), errStream);
        }
        return IoUtil.read(shell.getInputStream(), charset);
    }
}

