/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.wit;

import java.io.File;
import java.util.Map;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.map.Dict;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.TemplateException;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.wit.WitTemplate;
import org.febit.wit.Engine;
import org.febit.wit.exceptions.ResourceNotFoundException;
import org.febit.wit.util.Props;

public class WitEngine
implements TemplateEngine {
    private Engine engine;

    public WitEngine() {
    }

    public WitEngine(TemplateConfig config) {
        this.init(config);
    }

    public WitEngine(Engine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        this.init(WitEngine.createEngine(config));
        return this;
    }

    private void init(Engine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        try {
            return WitTemplate.wrap(this.engine.getTemplate(resource));
        }
        catch (ResourceNotFoundException e) {
            throw new TemplateException(e);
        }
    }

    @Override
    public Engine getRaw() {
        return this.engine;
    }

    private static Engine createEngine(TemplateConfig config) {
        Props configProps = Engine.createConfigProps((String)"");
        Dict dict = null;
        if (null != config) {
            dict = Dict.of();
            dict.set("DEFAULT_ENCODING", config.getCharset());
            switch (config.getResourceMode()) {
                case CLASSPATH: {
                    configProps.set("pathLoader.root", config.getPath());
                    configProps.set("routeLoader.defaultLoader", "classpathLoader");
                    break;
                }
                case STRING: {
                    configProps.set("routeLoader.defaultLoader", "stringLoader");
                    break;
                }
                case FILE: {
                    configProps.set("pathLoader.root", config.getPath());
                    configProps.set("routeLoader.defaultLoader", "fileLoader");
                    break;
                }
                case WEB_ROOT: {
                    File root = FileUtil.file(FileUtil.getWebRoot(), config.getPath());
                    configProps.set("pathLoader.root", FileUtil.getAbsolutePath(root));
                    configProps.set("routeLoader.defaultLoader", "fileLoader");
                }
            }
        }
        return Engine.create((Props)configProps, (Map)dict);
    }
}

