/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client;

import java.net.HttpCookie;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.meta.HeaderName;

public interface HeaderOperation<T extends HeaderOperation<T>> {
    public Map<String, ? extends Collection<String>> headers();

    public T header(String var1, String var2, boolean var3);

    default public String header(HeaderName headerName) {
        return this.header(headerName.getValue());
    }

    default public String header(String name) {
        Collection<String> values = this.headers().get(name);
        if (ArrayUtil.isNotEmpty(values)) {
            return CollUtil.getFirst(values);
        }
        return null;
    }

    default public T header(HeaderName name, String value, boolean isOverride) {
        return this.header(name.toString(), value, isOverride);
    }

    default public T header(HeaderName name, String value) {
        return this.header(name.toString(), value, true);
    }

    default public T header(String name, String value) {
        return this.header(name, value, true);
    }

    default public T header(Map<String, ? extends Collection<String>> headerMap, boolean isOverride) {
        if (MapUtil.isNotEmpty(headerMap)) {
            for (Map.Entry<String, ? extends Collection<String>> entry : headerMap.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    this.header(name, StrUtil.emptyIfNull(value), isOverride);
                }
            }
        }
        return (T)this;
    }

    default public T header(Map<String, String> headerMap) {
        if (MapUtil.isEmpty(headerMap)) {
            return (T)this;
        }
        LinkedHashMap headerMaps = new LinkedHashMap(this.headers().size());
        headerMap.forEach((key, value) -> headerMaps.put(key, ListUtil.of(value)));
        return this.header(headerMaps, true);
    }

    default public T contentType(String contentType) {
        this.header(HeaderName.CONTENT_TYPE, contentType);
        return (T)this;
    }

    default public T keepAlive(boolean isKeepAlive) {
        this.header(HeaderName.CONNECTION, isKeepAlive ? "Keep-Alive" : "Close");
        return (T)this;
    }

    default public T bearerAuth(String token) {
        return this.auth("Bearer " + token);
    }

    default public T auth(String content) {
        this.header(HeaderName.AUTHORIZATION, content, true);
        return (T)this;
    }

    default public T proxyAuth(String content) {
        this.header(HeaderName.PROXY_AUTHORIZATION, content, true);
        return (T)this;
    }

    default public T cookie(Collection<HttpCookie> cookies) {
        return this.cookie(CollUtil.isEmpty(cookies) ? null : cookies.toArray(new HttpCookie[0]));
    }

    default public T cookie(HttpCookie ... cookies) {
        if (ArrayUtil.isEmpty(cookies)) {
            return this.disableCookie();
        }
        return this.cookie(ArrayUtil.join(cookies, (CharSequence)"; "));
    }

    default public T cookie(String cookie) {
        return this.header(HeaderName.COOKIE, cookie, true);
    }

    default public T disableCookie() {
        return this.cookie("");
    }

    default public T enableDefaultCookie() {
        return this.cookie((String)null);
    }
}

