/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.serialize;

import java.time.MonthDay;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.date.DateUtil;
import org.dromara.hutool.core.date.TemporalAccessorUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.serialize.JSONStringer;

public class DateJSONString
implements JSONStringer {
    final Object dateObj;
    final JSONConfig jsonConfig;

    public DateJSONString(Object dateObj, JSONConfig jsonConfig) {
        this.dateObj = dateObj;
        this.jsonConfig = jsonConfig;
    }

    @Override
    public Object getRaw() {
        return this.dateObj;
    }

    @Override
    public String toJSONString() {
        if (this.dateObj instanceof MonthDay) {
            return InternalJSONUtil.quote(this.dateObj.toString());
        }
        return DateJSONString.formatDate(this.dateObj, this.jsonConfig.getDateFormat());
    }

    private static String formatDate(Object dateObj, String format) {
        long timeMillis;
        if (StrUtil.isNotBlank(format)) {
            String dateStr = dateObj instanceof TemporalAccessor ? TemporalAccessorUtil.format((TemporalAccessor)dateObj, format) : DateUtil.format(Convert.toDate(dateObj), format);
            if ("#sss".equals(format) || "#SSS".equals(format)) {
                return dateStr;
            }
            return InternalJSONUtil.quote(dateStr);
        }
        if (dateObj instanceof TemporalAccessor) {
            timeMillis = TemporalAccessorUtil.toEpochMilli((TemporalAccessor)dateObj);
        } else if (dateObj instanceof Date) {
            timeMillis = ((Date)dateObj).getTime();
        } else if (dateObj instanceof Calendar) {
            timeMillis = ((Calendar)dateObj).getTimeInMillis();
        } else {
            throw new UnsupportedOperationException("Unsupported Date type: " + dateObj.getClass());
        }
        return String.valueOf(timeMillis);
    }
}

