/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.socket.nio;

import java.io.IOException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.log.LogUtil;
import org.dromara.hutool.socket.nio.ChannelUtil;
import org.dromara.hutool.socket.nio.NioServer;
import org.dromara.hutool.socket.nio.Operation;

public class AcceptHandler
implements CompletionHandler<ServerSocketChannel, NioServer> {
    @Override
    public void completed(ServerSocketChannel serverSocketChannel, NioServer nioServer) {
        SocketChannel socketChannel;
        try {
            socketChannel = serverSocketChannel.accept();
            LogUtil.debug("Client [{}] accepted.", socketChannel.getRemoteAddress());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        ChannelUtil.registerChannel(nioServer.getSelector(), socketChannel, Operation.READ);
    }

    @Override
    public void failed(Throwable exc, NioServer nioServer) {
        LogUtil.error(exc);
    }
}

