/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.ai.model.openai;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dromara.hutool.ai.core.AIConfig;
import org.dromara.hutool.ai.core.BaseAIService;
import org.dromara.hutool.ai.core.Message;
import org.dromara.hutool.ai.model.openai.OpenaiCommon;
import org.dromara.hutool.ai.model.openai.OpenaiService;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.thread.ThreadUtil;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.json.JSONUtil;

public class OpenaiServiceImpl
extends BaseAIService
implements OpenaiService {
    private final String CHAT_ENDPOINT = "/chat/completions";
    private final String IMAGES_GENERATIONS = "/images/generations";
    private final String IMAGES_EDITS = "/images/edits";
    private final String IMAGES_VARIATIONS = "/images/variations";
    private final String TTS = "/audio/speech";
    private final String STT = "/audio/transcriptions";
    private final String EMBEDDINGS = "/embeddings";
    private final String MODERATIONS = "/moderations";

    public OpenaiServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chat(List<Message> messages, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatStreamRequestBody(messages);
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), "openai-chat-sse").start();
    }

    @Override
    public String chatVision(String prompt, List<String> images, String detail) {
        String paramJson = this.buildChatVisionRequestBody(prompt, images, detail);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chatVision(String prompt, List<String> images, String detail, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatVisionStreamRequestBody(prompt, images, detail);
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), "openai-chatVision-sse").start();
    }

    @Override
    public String imagesGenerations(String prompt) {
        String paramJson = this.buildImagesGenerationsRequestBody(prompt);
        Response response = this.sendPost("/images/generations", paramJson);
        return response.bodyStr();
    }

    @Override
    public String imagesEdits(String prompt, File image, File mask) {
        Map<String, Object> paramMap = this.buildImagesEditsRequestBody(prompt, image, mask);
        Response response = this.sendFormData("/images/edits", paramMap);
        return response.bodyStr();
    }

    @Override
    public String imagesVariations(File image) {
        Map<String, Object> paramMap = this.buildImagesVariationsRequestBody(image);
        Response response = this.sendFormData("/images/variations", paramMap);
        return response.bodyStr();
    }

    @Override
    public InputStream textToSpeech(String input, OpenaiCommon.OpenaiSpeech voice) {
        String paramJson = this.buildTTSRequestBody(input, voice.getVoice());
        Response response = this.sendPost("/audio/speech", paramJson);
        return response.bodyStream();
    }

    @Override
    public String speechToText(File file) {
        Map<String, Object> paramMap = this.buildSTTRequestBody(file);
        Response response = this.sendFormData("/audio/transcriptions", paramMap);
        return response.bodyStr();
    }

    @Override
    public String embeddingText(String input) {
        String paramJson = this.buildEmbeddingTextRequestBody(input);
        Response response = this.sendPost("/embeddings", paramJson);
        return response.bodyStr();
    }

    @Override
    public String moderations(String text, String imgUrl) {
        String paramJson = this.buileModerationsRequestBody(text, imgUrl);
        Response response = this.sendPost("/moderations", paramJson);
        return response.bodyStr();
    }

    @Override
    public String chatReasoning(List<Message> messages, String reasoningEffort) {
        String paramJson = this.buildChatReasoningRequestBody(messages, reasoningEffort);
        Response response = this.sendPost("/chat/completions", paramJson);
        return response.bodyStr();
    }

    @Override
    public void chatReasoning(List<Message> messages, String reasoningEffort, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatReasoningStreamRequestBody(messages, reasoningEffort);
        ThreadUtil.newThread(() -> this.sendPostStream("/chat/completions", paramMap, callback::accept), "openai-chatReasoning-sse").start();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatStreamRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildChatVisionRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatVisionStreamRequestBody(String prompt, List<String> images, String detail) {
        ArrayList<Message> messages = new ArrayList<Message>();
        ArrayList content = new ArrayList();
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("type", "text");
        contentMap.put("text", prompt);
        content.add(contentMap);
        for (String img : images) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", img);
            urlMap.put("detail", detail);
            imgUrlMap.put("image_url", urlMap);
            content.add(imgUrlMap);
        }
        messages.add(new Message("user", content));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildImagesGenerationsRequestBody(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildImagesEditsRequestBody(String prompt, File image, File mask) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.put("image", image);
        if (mask != null) {
            paramMap.put("mask", mask);
        }
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private Map<String, Object> buildImagesVariationsRequestBody(File image) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("image", image);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildTTSRequestBody(String input, String voice) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("input", input);
        paramMap.put("voice", voice);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildSTTRequestBody(File file) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("file", file);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildEmbeddingTextRequestBody(String input) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("input", input);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buileModerationsRequestBody(String text, String imgUrl) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        ArrayList input = new ArrayList();
        if (!StrUtil.isBlank(text)) {
            HashMap<String, String> textMap = new HashMap<String, String>();
            textMap.put("type", "text");
            textMap.put("text", text);
            input.add(textMap);
        }
        if (!StrUtil.isBlank(imgUrl)) {
            HashMap<String, Object> imgUrlMap = new HashMap<String, Object>();
            imgUrlMap.put("type", "image_url");
            HashMap<String, String> urlMap = new HashMap<String, String>();
            urlMap.put("url", imgUrl);
            imgUrlMap.put("image_url", urlMap);
            input.add(imgUrlMap);
        }
        paramMap.put("input", input);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildChatReasoningRequestBody(List<Message> messages, String reasoningEffort) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.put("reasoning_effort", reasoningEffort);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatReasoningStreamRequestBody(List<Message> messages, String reasoningEffort) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.put("reasoning_effort", reasoningEffort);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }
}

