/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.compress;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.StandardCopyOption;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.dromara.hutool.core.compress.ZipFileResource;
import org.dromara.hutool.core.compress.ZipResource;
import org.dromara.hutool.core.compress.ZipStreamResource;
import org.dromara.hutool.core.compress.ZipUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;

public class ZipReader
implements Closeable {
    private static final int DEFAULT_MAX_SIZE_DIFF = 100;
    private final ZipResource resource;
    private int maxSizeDiff = 100;

    public static ZipReader of(File zipFile, Charset charset) {
        return new ZipReader(ZipUtil.toZipFile(zipFile, charset));
    }

    public static ZipReader of(InputStream in, Charset charset) {
        return new ZipReader(new ZipInputStream(in, charset));
    }

    public ZipReader(ZipFile zipFile) {
        this(new ZipFileResource(zipFile));
    }

    public ZipReader(ZipInputStream zin) {
        this(new ZipStreamResource(zin));
    }

    public ZipReader(ZipResource resource) {
        this.resource = resource;
    }

    public ZipReader setMaxSizeDiff(int maxSizeDiff) {
        this.maxSizeDiff = maxSizeDiff;
        return this;
    }

    public InputStream get(String path) {
        return this.resource.get(path);
    }

    public File readTo(File outFile) throws IORuntimeException {
        return this.readTo(outFile, null);
    }

    public File readTo(File outFile, Predicate<ZipEntry> entryFilter) throws IORuntimeException {
        this.read(zipEntry -> {
            if (null == entryFilter || entryFilter.test((ZipEntry)zipEntry)) {
                this.readEntry((ZipEntry)zipEntry, outFile);
            }
        });
        return outFile;
    }

    public ZipReader read(Consumer<ZipEntry> consumer) throws IORuntimeException {
        this.resource.read(consumer, this.maxSizeDiff);
        return this;
    }

    @Override
    public void close() throws IORuntimeException {
        IoUtil.closeQuietly(this.resource);
    }

    private void readEntry(ZipEntry zipEntry, File outFile) {
        String path = zipEntry.getName();
        if (FileUtil.isWindows()) {
            path = StrUtil.replace((CharSequence)path, (CharSequence)"*", "_");
        }
        File outItemFile = FileUtil.file(outFile, path);
        if (zipEntry.isDirectory()) {
            outItemFile.mkdirs();
        } else {
            FileUtil.copy(this.resource.get(zipEntry), outItemFile, new StandardCopyOption[0]);
        }
    }
}

