/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.ReaderWrapper;
import org.dromara.hutool.core.io.stream.BOMInputStream;
import org.dromara.hutool.core.lang.Assert;

public class BomReader
extends ReaderWrapper {
    public BomReader(InputStream in) {
        super(BomReader.initReader(in));
    }

    private static InputStreamReader initReader(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        BOMInputStream bin = in instanceof BOMInputStream ? (BOMInputStream)in : new BOMInputStream(in);
        try {
            return new InputStreamReader((InputStream)bin, bin.getCharset());
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }
}

