/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.buffer;

import org.dromara.hutool.core.io.buffer.FastBuffer;
import org.dromara.hutool.core.lang.Assert;

public class FastCharBuffer
extends FastBuffer
implements CharSequence,
Appendable {
    private char[][] buffers = new char[16][];
    private char[] currentBuffer;

    public FastCharBuffer() {
        this(1024);
    }

    public FastCharBuffer(int size) {
        super(size);
    }

    public FastCharBuffer append(char[] array, int off, int len) {
        int part;
        int end = off + len;
        if (off < 0 || len < 0 || end > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newSize = this.size + len;
        int remaining = len;
        if (this.currentBuffer != null) {
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            remaining -= part;
            this.offset += part;
            this.size += part;
        }
        if (remaining > 0) {
            this.ensureCapacity(newSize);
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.size += part;
        }
        return this;
    }

    public FastCharBuffer append(char[] array) {
        return this.append(array, 0, array.length);
    }

    @Override
    public FastCharBuffer append(char element) {
        if (this.currentBuffer == null || this.offset == this.currentBuffer.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.currentBuffer[this.offset] = element;
        ++this.offset;
        ++this.size;
        return this;
    }

    public FastCharBuffer append(FastCharBuffer buff) {
        if (buff.size == 0) {
            return this;
        }
        for (int i = 0; i < buff.currentBufferIndex; ++i) {
            this.append(buff.buffers[i]);
        }
        this.append(buff.currentBuffer, 0, buff.offset);
        return this;
    }

    public char[] array(int index) {
        return this.buffers[index];
    }

    @Override
    public void reset() {
        super.reset();
        this.currentBuffer = null;
    }

    public char[] toArrayZeroCopyIfPossible() {
        int len;
        if (1 == this.currentBufferIndex && (len = this.buffers[0].length) == this.size) {
            return this.buffers[0];
        }
        return this.toArray();
    }

    public char[] toArray() {
        return this.toArray(0, this.size);
    }

    public char[] toArray(int start, int len) {
        Assert.isTrue(start >= 0, "Start must be greater than zero!", new Object[0]);
        Assert.isTrue(len >= 0, "Length must be greater than zero!", new Object[0]);
        if (start >= this.size || len == 0) {
            return new char[0];
        }
        if (len > this.size - start) {
            len = this.size - start;
        }
        int remaining = len;
        int pos = 0;
        char[] result = new char[len];
        int i = 0;
        while (start >= this.buffers[i].length) {
            start -= this.buffers[i].length;
            ++i;
        }
        while (i < this.buffersCount) {
            char[] buf = this.buffers[i];
            int bufLen = Math.min(buf.length - start, remaining);
            System.arraycopy(buf, start, result, pos, bufLen);
            pos += bufLen;
            if ((remaining -= bufLen) == 0) break;
            start = 0;
            ++i;
        }
        return result;
    }

    public char get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        char[] b;
        while (index >= (b = this.buffers[ndx]).length) {
            ++ndx;
            index -= b.length;
        }
        return b[index];
    }

    @Override
    public String toString() {
        return new String(this.toArray());
    }

    @Override
    public char charAt(int index) {
        return this.get(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int len = end - start;
        return new StringBuilder(len).append(this.toArray(start, len));
    }

    @Override
    public FastCharBuffer append(CharSequence csq) {
        if (csq instanceof String) {
            return this.append((String)csq);
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    public FastCharBuffer append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this;
    }

    public FastCharBuffer append(String string) {
        int part;
        int len = string.length();
        if (len == 0) {
            return this;
        }
        int newSize = this.size + len;
        int remaining = len;
        int start = 0;
        if (this.currentBuffer != null) {
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            string.getChars(0, part, this.currentBuffer, this.offset);
            remaining -= part;
            this.offset += part;
            this.size += part;
            start += part;
        }
        if (remaining > 0) {
            this.ensureCapacity(newSize);
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            string.getChars(start, start + part, this.currentBuffer, this.offset);
            this.offset += part;
            this.size += part;
        }
        return this;
    }

    @Override
    protected void ensureCapacity(int capacity) {
        int delta = capacity - this.size;
        int newBufferSize = Math.max(this.minChunkLen, delta);
        ++this.currentBufferIndex;
        this.currentBuffer = new char[newBufferSize];
        this.offset = 0;
        if (this.currentBufferIndex >= this.buffers.length) {
            int newLen = this.buffers.length << 1;
            char[][] newBuffers = new char[newLen][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        this.buffers[this.currentBufferIndex] = this.currentBuffer;
        ++this.buffersCount;
    }
}

