/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.hutool.core.lang.Assert;

public class LimitedInputStream
extends FilterInputStream {
    protected long limit;
    private final boolean throwWhenReachLimit;

    public LimitedInputStream(InputStream in, long limit) {
        this(in, limit, true);
    }

    public LimitedInputStream(InputStream in, long limit, boolean throwWhenReachLimit) {
        super(Assert.notNull(in, "InputStream must not be null!", new Object[0]));
        this.limit = Math.max(0L, limit);
        this.throwWhenReachLimit = throwWhenReachLimit;
    }

    @Override
    public int read() throws IOException {
        int data = this.limit == 0L ? -1 : super.read();
        this.checkLimit(data);
        this.limit = data < 0 ? 0L : this.limit - 1L;
        return data;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.limit == 0L ? -1 : super.read(b, off, (long)len > this.limit ? (int)this.limit : len);
        this.checkLimit(length);
        this.limit = length < 0 ? 0L : this.limit - (long)length;
        return length;
    }

    @Override
    public long skip(long len) throws IOException {
        long length = super.skip(Math.min(len, this.limit));
        this.checkLimit(length);
        this.limit -= length;
        return length;
    }

    @Override
    public int available() throws IOException {
        int length = super.available();
        return (long)length > this.limit ? (int)this.limit : length;
    }

    private void checkLimit(long data) throws IOException {
        if (data < 0L && this.limit > 0L && this.throwWhenReachLimit) {
            throw new IOException("Read limit exceeded");
        }
    }
}

