/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Predicate;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.core.io.stream.ValidateObjectInputStream;

public class StreamReader {
    private final InputStream in;
    private final boolean closeAfterRead;

    public static StreamReader of(InputStream in, boolean closeAfterRead) {
        return new StreamReader(in, closeAfterRead);
    }

    public StreamReader(InputStream in, boolean closeAfterRead) {
        this.in = in;
        this.closeAfterRead = closeAfterRead;
    }

    public byte[] readBytes() throws IORuntimeException {
        return this.readBytes(-1);
    }

    public byte[] readBytes(int length) throws IORuntimeException {
        InputStream in = this.in;
        if (null == in || length == 0) {
            return new byte[0];
        }
        return this.read(length).toByteArrayZeroCopyIfPossible();
    }

    public FastByteArrayOutputStream read() throws IORuntimeException {
        return this.read(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FastByteArrayOutputStream read(int limit) throws IORuntimeException {
        InputStream in = this.in;
        FastByteArrayOutputStream out = FastByteArrayOutputStream.of(in, limit);
        try {
            IoUtil.copy(in, out, 8192, (long)limit, null);
            if (!this.closeAfterRead) return out;
        }
        catch (Throwable throwable) {
            if (!this.closeAfterRead) throw throwable;
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        return out;
    }

    public FastByteArrayOutputStream readTo(Predicate<Integer> predicate) throws IORuntimeException {
        InputStream in = this.in;
        FastByteArrayOutputStream out = FastByteArrayOutputStream.of(in, -1);
        try {
            int read;
            while (!((read = in.read()) <= 0 || null != predicate && predicate.test(read))) {
                out.write(read);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return out;
    }

    public <T> T readObj(Class<?> ... acceptClasses) throws IORuntimeException, HutoolException {
        ValidateObjectInputStream validateIn;
        InputStream in = this.in;
        if (null == in) {
            return null;
        }
        if (in instanceof ValidateObjectInputStream) {
            validateIn = (ValidateObjectInputStream)in;
            validateIn.accept(acceptClasses);
        } else {
            try {
                validateIn = new ValidateObjectInputStream(in, acceptClasses);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        try {
            return (T)validateIn.readObject();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new HutoolException(e);
        }
    }
}

