/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.lang.selector;

import java.util.ArrayList;
import java.util.List;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.selector.Selector;
import org.dromara.hutool.core.lang.selector.SmoothWeightObj;
import org.dromara.hutool.core.lang.selector.WeightObj;

public class SmoothWeightSelector<T>
implements Selector<T> {
    private final List<SmoothWeightObj<T>> objList = new ArrayList<SmoothWeightObj<T>>();

    public static <T> SmoothWeightSelector<T> of() {
        return new SmoothWeightSelector<T>();
    }

    public SmoothWeightSelector() {
    }

    public SmoothWeightSelector(Iterable<? extends WeightObj<T>> weightObjList) {
        this();
        for (WeightObj<T> weightObj : weightObjList) {
            this.add(weightObj);
        }
    }

    public SmoothWeightSelector<T> add(T obj, int weight) {
        return this.add(new SmoothWeightObj<T>(obj, weight));
    }

    public SmoothWeightSelector<T> add(WeightObj<T> weightObj) {
        SmoothWeightObj smoothWeightObj = weightObj instanceof SmoothWeightObj ? (SmoothWeightObj)weightObj : new SmoothWeightObj(weightObj.obj, weightObj.weight);
        this.objList.add(smoothWeightObj);
        return this;
    }

    @Override
    public T select() {
        if (CollUtil.isEmpty(this.objList)) {
            return null;
        }
        int totalWeight = 0;
        SmoothWeightObj<T> selected = null;
        for (SmoothWeightObj<T> obj : this.objList) {
            totalWeight += obj.getWeight();
            int currentWeight = obj.getCurrentWeight() + obj.getWeight();
            obj.setCurrentWeight(currentWeight);
            if (null != selected && currentWeight <= selected.getCurrentWeight()) continue;
            selected = obj;
        }
        if (null == selected) {
            return null;
        }
        selected.setCurrentWeight(selected.getCurrentWeight() - totalWeight);
        return selected.getObj();
    }
}

