/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.math;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.text.CharUtil;
import org.dromara.hutool.core.text.StrUtil;

public class NumberParser {
    public static final NumberParser INSTANCE = NumberParser.of(null);
    private static final String NaN = "NaN";
    private final Locale locale;
    private final boolean zeroIfNaN;

    public static NumberParser of(Locale locale) {
        return NumberParser.of(locale, true);
    }

    public static NumberParser of(Locale locale, boolean zeroIfNaN) {
        return new NumberParser(locale, zeroIfNaN);
    }

    public NumberParser(Locale locale, boolean zeroIfNaN) {
        this.locale = locale;
        this.zeroIfNaN = zeroIfNaN;
    }

    public int parseInt(String numberStr) throws NumberFormatException {
        if (this.isBlankOrNaN(numberStr)) {
            return 0;
        }
        if (StrUtil.startWithIgnoreCase(numberStr, "0x")) {
            return Integer.parseInt(numberStr.substring(2), 16);
        }
        if (StrUtil.containsIgnoreCase(numberStr, "E")) {
            throw new NumberFormatException(StrUtil.format("Unsupported int format: [{}]", numberStr));
        }
        try {
            return Integer.parseInt(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).intValue();
        }
    }

    public int parseInt(char[] chars, int radix) {
        if (ArrayUtil.isEmpty(chars)) {
            throw new IllegalArgumentException("Empty chars!");
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int limit = -2147483647;
        while (CharUtil.isBlankChar(chars[i])) {
            ++i;
        }
        char firstChar = chars[i];
        if (firstChar < '0') {
            if (firstChar == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
            } else if (firstChar != '+') {
                throw new NumberFormatException("Invalid first char: " + firstChar);
            }
            if (chars.length == 1) {
                throw new NumberFormatException("Invalid chars has lone: " + firstChar);
            }
            ++i;
        }
        int multmin = limit / radix;
        while (i < chars.length) {
            int digit;
            if (CharUtil.isBlankChar(chars[i])) {
                ++i;
                continue;
            }
            if ((digit = Character.digit(chars[i++], radix)) < 0) {
                throw new NumberFormatException(StrUtil.format("Invalid chars: {} at {}", chars, i - 1));
            }
            if (result < multmin) {
                throw new NumberFormatException(StrUtil.format("Invalid chars: {}", new Object[]{chars}));
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException(StrUtil.format("Invalid chars: {}", new Object[]{chars}));
            }
            result -= digit;
        }
        return negative ? result : -result;
    }

    public long parseLong(String numberStr) {
        if (this.isBlankOrNaN(numberStr)) {
            return 0L;
        }
        if (StrUtil.startWithIgnoreCase(numberStr, "0x")) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        try {
            return Long.parseLong(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).longValue();
        }
    }

    public float parseFloat(String numberStr) {
        if (this.isBlankOrNaN(numberStr)) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).floatValue();
        }
    }

    public double parseDouble(String numberStr) {
        if (this.isBlankOrNaN(numberStr)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(numberStr);
        }
        catch (NumberFormatException e) {
            return this.doParse(numberStr).doubleValue();
        }
    }

    public BigInteger parseBigInteger(String str) {
        if (null == (str = StrUtil.trimToNull(str))) {
            return null;
        }
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        if (pos > 0) {
            str = str.substring(pos);
        }
        BigInteger value = new BigInteger(str, radix);
        return negate ? value.negate() : value;
    }

    public Number parseNumber(String numberStr) throws NumberFormatException {
        if (this.isBlankOrNaN(numberStr)) {
            return 0;
        }
        if (StrUtil.startWithIgnoreCase(numberStr, "0x")) {
            return Long.parseLong(numberStr.substring(2), 16);
        }
        return this.doParse(numberStr);
    }

    private Number doParse(String numberStr) {
        Locale locale = this.locale;
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        if (StrUtil.startWith((CharSequence)numberStr, '+')) {
            numberStr = StrUtil.subSuf(numberStr, 1);
        }
        try {
            NumberFormat format = NumberFormat.getInstance(locale);
            if (format instanceof DecimalFormat) {
                ((DecimalFormat)format).setParseBigDecimal(true);
            }
            return format.parse(numberStr);
        }
        catch (ParseException e) {
            NumberFormatException nfe = new NumberFormatException(e.getMessage());
            nfe.initCause(e);
            throw nfe;
        }
    }

    private boolean isBlankOrNaN(String numberStr) throws NumberFormatException {
        if (StrUtil.isBlank(numberStr)) {
            return true;
        }
        if (NaN.equals(numberStr)) {
            if (this.zeroIfNaN) {
                return true;
            }
            throw new NumberFormatException("Can not parse NaN when 'zeroIfNaN' is false!");
        }
        return false;
    }
}

