/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.cron.pattern.builder;

import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.core.text.StrJoiner;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.cron.pattern.Part;
import org.dromara.hutool.cron.pattern.builder.PartBuilder;

public class PatternBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    final String[] parts = new String[7];

    public static PatternBuilder of() {
        return new PatternBuilder();
    }

    public PatternBuilder setValues(Part part, int ... values) {
        for (int value : values) {
            part.checkValue(value);
        }
        return this.set(part, new PartBuilder.And(values));
    }

    public PatternBuilder setRange(Part part, int begin, int end) {
        Assert.notNull(part);
        part.checkValue(begin);
        part.checkValue(end);
        return this.set(part, new PartBuilder.Range(begin, end));
    }

    public PatternBuilder setYear(PartBuilder value) {
        return this.set(Part.YEAR, value);
    }

    public PatternBuilder setDayOfWeek(PartBuilder value) {
        return this.set(Part.DAY_OF_WEEK, value);
    }

    public PatternBuilder setMonth(PartBuilder value) {
        return this.set(Part.MONTH, value);
    }

    public PatternBuilder setDayOfMonth(PartBuilder value) {
        return this.set(Part.DAY_OF_MONTH, value);
    }

    public PatternBuilder setHour(PartBuilder value) {
        return this.set(Part.HOUR, value);
    }

    public PatternBuilder setMinute(PartBuilder value) {
        return this.set(Part.MINUTE, value);
    }

    public PatternBuilder setSecond(PartBuilder value) {
        return this.set(Part.SECOND, value);
    }

    public PatternBuilder set(Part part, PartBuilder value) {
        return this.set(part, ObjUtil.apply(value, Builder::build));
    }

    public PatternBuilder set(Part part, String value) {
        this.parts[part.ordinal()] = value;
        return this;
    }

    @Override
    public String build() {
        for (int i = Part.MINUTE.ordinal(); i < Part.YEAR.ordinal(); ++i) {
            if (!StrUtil.isBlank(this.parts[i])) continue;
            this.parts[i] = "*";
        }
        return StrJoiner.of(" ").setNullMode(StrJoiner.NullMode.IGNORE).append((T[])this.parts).toString();
    }
}

