/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric.paillier;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.CipherSpi;
import javax.crypto.NoSuchPaddingException;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierKey;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierPrivateKey;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierPublicKey;

class PaillierCipherSpiImpl
extends CipherSpi {
    protected SecureRandom random = RandomUtil.getSecureRandom();
    protected int stateMode;
    protected Key key;
    protected int plaintextSize;
    protected int ciphertextSize;
    protected byte[] dataBuffer;
    protected int lengthBuffer;

    PaillierCipherSpiImpl() {
    }

    @Override
    protected void engineInit(int mode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(mode, key, random);
    }

    @Override
    protected void engineInit(int mode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException {
        this.engineInit(mode, key, random);
    }

    @Override
    protected void engineInit(int mode, Key key, SecureRandom random) throws InvalidKeyException {
        this.checkKey(key, mode);
        this.stateMode = mode;
        this.key = key;
        if (null != random) {
            this.random = random;
        }
        int modulusLength = ((PaillierKey)key).getN().bitLength();
        this.calculateBlockSizes(modulusLength);
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] out = new byte[this.engineGetOutputSize(inputLen)];
        int length = this.engineUpdate(input, inputOffset, inputLen, out, 0);
        if (length < out.length) {
            byte[] shorter = new byte[length];
            System.arraycopy(out, 0, shorter, 0, length);
            out = shorter;
        }
        return out;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int lengthBuffer = this.getDataBufferedLength();
        byte[] totalIn = new byte[inputLen + lengthBuffer];
        this.readFromBufferAndReset(totalIn);
        System.arraycopy(input, inputOffset, totalIn, lengthBuffer, inputLen);
        int blockSize = this.engineGetBlockSize();
        int lastBlockSize = totalIn.length % blockSize;
        int lastBlockOffset = totalIn.length - lastBlockSize;
        int outputLength = 0;
        for (int i = 0; i < lastBlockOffset; i += blockSize) {
            outputLength += this.engineTransformBlock(totalIn, i, blockSize, output, outputOffset + outputLength);
        }
        this.addToBuffer(totalIn, lastBlockOffset, lastBlockSize);
        return outputLength;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) {
        byte[] out = new byte[this.engineGetOutputSize(inputLen)];
        int length = this.engineDoFinal(input, inputOffset, inputLen, out, 0);
        if (length < out.length) {
            byte[] smaller = new byte[length];
            System.arraycopy(out, 0, smaller, 0, length);
            return smaller;
        }
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) {
        int blockSize;
        int lastBlockSize;
        int lengthBuffer = this.getDataBufferedLength();
        byte[] totalIn = new byte[inputLen + lengthBuffer];
        this.readFromBufferAndReset(totalIn);
        if (inputLen > 0) {
            System.arraycopy(input, inputOffset, totalIn, lengthBuffer, inputLen);
        }
        if ((lastBlockSize = totalIn.length % (blockSize = this.engineGetBlockSize())) == 0 && totalIn.length > 0) {
            lastBlockSize = blockSize;
        }
        int lastBlockOffset = totalIn.length - lastBlockSize;
        int outputLength = 0;
        for (int i = 0; i < lastBlockOffset; i += blockSize) {
            outputLength += this.engineTransformBlock(totalIn, i, blockSize, output, outputOffset + outputLength);
        }
        outputLength += this.engineTransformBlockFinal(totalIn, lastBlockOffset, lastBlockSize, output, outputOffset + outputLength);
        return outputLength;
    }

    @Override
    protected int engineGetBlockSize() {
        if (this.stateMode == 2) {
            return this.ciphertextSize;
        }
        return this.plaintextSize;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        int outLength;
        if (this.stateMode == 1) {
            int inBlocks = (inputLen + this.getDataBufferedLength() + this.plaintextSize - 1) / this.plaintextSize;
            outLength = inBlocks * this.ciphertextSize;
        } else {
            int inBlocks = (inputLen + this.getDataBufferedLength() + this.plaintextSize - 1) / this.ciphertextSize;
            outLength = inBlocks * this.plaintextSize;
        }
        return outLength;
    }

    @Override
    protected final void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Paillier supports no modes.");
    }

    @Override
    protected final void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Paillier supports no padding.");
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    private void checkKey(Key key, int mode) throws InvalidKeyException {
        if (mode == 1) {
            if (!(key instanceof PaillierPublicKey)) {
                throw new InvalidKeyException("I didn't get a PaillierPublicKey.");
            }
        } else if (mode == 2) {
            if (!(key instanceof PaillierPrivateKey)) {
                throw new InvalidKeyException("I didn't get a PaillierPrivateKey. ");
            }
        } else {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
    }

    private byte[] getBytes(BigInteger big) {
        byte[] bigBytes = big.toByteArray();
        if (big.bitLength() % 8 != 0) {
            return bigBytes;
        }
        byte[] smallerBytes = new byte[big.bitLength() / 8];
        System.arraycopy(bigBytes, 1, smallerBytes, 0, smallerBytes.length);
        return smallerBytes;
    }

    private void calculateBlockSizes(int modulusLength) {
        this.plaintextSize = (modulusLength - 1) / 8;
        this.ciphertextSize = (modulusLength + 7) / 8 * 2;
    }

    private int engineTransformBlockFinal(byte[] input, int inputOffset, int inputLenth, byte[] output, int outputOffset) {
        if (inputLenth == 0) {
            return 0;
        }
        return this.engineTransformBlock(input, inputOffset, inputLenth, output, outputOffset);
    }

    private int engineTransformBlock(byte[] input, int inputOffset, int inputLenth, byte[] output, int outputOffset) {
        if (this.stateMode == 1) {
            return this.encryptBlock(input, inputOffset, inputLenth, output, outputOffset);
        }
        if (this.stateMode == 2) {
            return this.decryptBlock(input, inputOffset, output, outputOffset);
        }
        return 0;
    }

    private int encryptBlock(byte[] input, int inputOffset, int inputLenth, byte[] output, int outputOffset) throws CryptoException {
        byte[] messageBytes = new byte[this.plaintextSize];
        int inLenth = Math.min(this.plaintextSize, inputLenth);
        System.arraycopy(input, inputOffset, messageBytes, 0, inLenth);
        BigInteger m = new BigInteger(1, messageBytes);
        PaillierPublicKey key = (PaillierPublicKey)this.key;
        BigInteger g = key.getG();
        BigInteger n = key.getN();
        BigInteger nsquare = key.getNSquare();
        BigInteger r = key.generateRandomRinZn(this.random);
        if (m.compareTo(BigInteger.ZERO) < 0 || m.compareTo(n) >= 0) {
            throw new CryptoException("PaillierCipher.encryptBlock :Plaintext m is not in Z_n , m should be less then n");
        }
        BigInteger c = g.modPow(m, nsquare).multiply(r.modPow(n, nsquare)).mod(nsquare);
        byte[] cBytes = this.getBytes(c);
        System.arraycopy(cBytes, 0, output, outputOffset + this.ciphertextSize - cBytes.length, cBytes.length);
        return this.ciphertextSize;
    }

    private int decryptBlock(byte[] input, int inputOffset, byte[] output, int outputOffset) {
        PaillierPrivateKey key = (PaillierPrivateKey)this.key;
        BigInteger u = key.getU();
        BigInteger lambda = key.getLambda();
        BigInteger n = key.getN();
        BigInteger nsquare = key.getNSquare();
        byte[] cBytes = new byte[this.ciphertextSize];
        System.arraycopy(input, inputOffset, cBytes, 0, this.ciphertextSize);
        BigInteger c = new BigInteger(1, cBytes);
        BigInteger m = c.modPow(lambda, nsquare).subtract(BigInteger.ONE).divide(n).multiply(u).mod(n);
        byte[] messageBytes = this.getBytes(m);
        int gatedLength = Math.min(messageBytes.length, this.plaintextSize);
        System.arraycopy(messageBytes, 0, output, outputOffset + this.plaintextSize - gatedLength, gatedLength);
        return this.plaintextSize;
    }

    private void readFromBufferAndReset(byte[] output) {
        this.checkBuffer();
        System.arraycopy(this.dataBuffer, 0, output, 0, this.lengthBuffer);
        this.lengthBuffer = 0;
    }

    private int getDataBufferedLength() {
        this.checkBuffer();
        return this.lengthBuffer;
    }

    private void checkBuffer() {
        if (this.dataBuffer == null || this.dataBuffer.length != this.engineGetBlockSize()) {
            this.dataBuffer = new byte[this.engineGetBlockSize()];
            this.lengthBuffer = 0;
        }
    }

    private void addToBuffer(byte[] input, int offset, int length) {
        this.checkBuffer();
        System.arraycopy(input, offset, this.dataBuffer, this.lengthBuffer, length);
        this.lengthBuffer += length;
    }
}

