/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;

public class SqlServer2005Dialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_TABLE_ALIAS = "table_alias_";
    private static final String DEFAULT_ROWNUM_ALIAS = "rownum_";

    @Override
    public String dialectName() {
        return DialectName.SQLSERVER.name();
    }

    public SqlServer2005Dialect(DbConfig dbConfig) {
        super(dbConfig);
        this.quoteWrapper = new QuoteWrapper(Character.valueOf('\"'));
    }

    @Override
    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        String distinctStr;
        String querySql = find.toString();
        String tableAlias = DEFAULT_TABLE_ALIAS;
        while (querySql.contains(tableAlias)) {
            tableAlias = tableAlias + "_";
        }
        String rownumAlias = DEFAULT_ROWNUM_ALIAS;
        while (querySql.contains(rownumAlias)) {
            rownumAlias = rownumAlias + "_";
        }
        String orderBy = SqlServer2005Dialect.getOrderByPart(querySql);
        if (StrUtil.startWithIgnoreCase(querySql, "select distinct")) {
            querySql = querySql.substring(15);
            distinctStr = "DISTINCT ";
        } else {
            querySql = querySql.substring(6);
            distinctStr = "";
        }
        return SqlBuilder.of("WITH " + tableAlias + " AS (SELECT " + distinctStr + "TOP 100 PERCENT  ROW_NUMBER() OVER (" + orderBy + ") as " + rownumAlias + ", " + querySql + ") SELECT * FROM " + tableAlias + " WHERE " + rownumAlias + " BETWEEN " + (page.getBeginIndex() + 1) + " AND " + page.getEndIndex() + " ORDER BY " + rownumAlias);
    }

    private static String getOrderByPart(String sql) {
        int orderByIndex = StrUtil.indexOfIgnoreCase(sql, "order by");
        return orderByIndex > -1 ? sql.substring(orderByIndex) : "ORDER BY CURRENT_TIMESTAMP";
    }
}

