/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.httpclient5;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.http.HttpException;
import org.dromara.hutool.http.client.cookie.CookieSpi;
import org.dromara.hutool.http.client.cookie.CookieStoreSpi;
import org.dromara.hutool.http.client.engine.httpclient5.HttpClient5Cookie;

public class HttpClient5CookieStore
extends SimpleWrapper<CookieStoreSpi>
implements CookieStore {
    public HttpClient5CookieStore(CookieStoreSpi cookieStore) {
        super(cookieStore);
    }

    public void addCookie(Cookie cookie) {
        URI uri;
        try {
            uri = new URI("http", cookie.getDomain(), cookie.getPath(), null);
        }
        catch (URISyntaxException e) {
            throw new HttpException(e);
        }
        ((CookieStoreSpi)this.raw).add(uri, new HttpClient5Cookie(cookie));
    }

    public List<Cookie> getCookies() {
        List<CookieSpi> cookies = ((CookieStoreSpi)this.raw).getCookies();
        ArrayList<Cookie> result = new ArrayList<Cookie>(cookies.size());
        for (CookieSpi cookie : cookies) {
            result.add((Cookie)((HttpClient5Cookie)cookie).getRaw());
        }
        return result;
    }

    public boolean clearExpired(Date date) {
        return this.clearExpired(date.toInstant());
    }

    public boolean clearExpired(Instant date) {
        boolean removeSome = false;
        for (URI uri : ((CookieStoreSpi)this.raw).getURIs()) {
            for (CookieSpi cookie : ((CookieStoreSpi)this.raw).get(uri)) {
                if (!cookie.isExpired(date)) continue;
                ((CookieStoreSpi)this.raw).remove(uri, cookie);
                removeSome = true;
            }
        }
        return removeSome;
    }

    public void clear() {
        ((CookieStoreSpi)this.raw).clear();
    }
}

