/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.okhttp;

import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.engine.EngineRequestBuilder;
import org.dromara.hutool.http.client.engine.okhttp.OkHttpRequestBody;

public class OkHttpRequestBuilder
implements EngineRequestBuilder<okhttp3.Request> {
    public static final OkHttpRequestBuilder INSTANCE = new OkHttpRequestBuilder();

    @Override
    public okhttp3.Request build(Request message) {
        Request.Builder builder = new Request.Builder().url(message.handledUrl().toURL());
        String method = message.method().name();
        HttpBody body = message.handledBody();
        if (null != body || HttpMethod.requiresRequestBody((String)method)) {
            builder.method(method, (RequestBody)new OkHttpRequestBody(body));
        } else {
            builder.method(method, null);
        }
        message.headers().forEach((key, values) -> values.forEach(value -> builder.addHeader(key, value)));
        return builder.build();
    }
}

