/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListWrapper;
import org.dromara.hutool.core.lang.Validator;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.json.JSON;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONFactory;
import org.dromara.hutool.json.JSONGetter;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.serializer.impl.ArrayTypeAdapter;
import org.dromara.hutool.json.serializer.impl.IterTypeAdapter;
import org.dromara.hutool.json.writer.JSONWriter;

public class JSONArray
extends ListWrapper<JSON>
implements JSON,
JSONGetter<Integer>,
RandomAccess {
    private static final long serialVersionUID = 2664900568717612292L;
    public static final int DEFAULT_CAPACITY = 10;
    private final JSONFactory factory;

    public JSONArray() {
        this(10);
    }

    public JSONArray(int initialCapacity) {
        this(initialCapacity, JSONFactory.getInstance());
    }

    public JSONArray(JSONConfig config) {
        this(10, config);
    }

    public JSONArray(int initialCapacity, JSONConfig config) {
        this(initialCapacity, JSONFactory.of(config, null));
    }

    public JSONArray(int initialCapacity, JSONFactory factory) {
        super(new ArrayList(initialCapacity));
        this.factory = factory;
    }

    @Override
    public JSONFactory getFactory() {
        return this.factory;
    }

    @Override
    public JSON getJSON(Integer key) {
        return (JSON)((List)this.raw).get(key);
    }

    public JSONArray addNull() {
        this.add(null);
        return this;
    }

    public JSONArray addValue(Boolean value) {
        this.add(this.factory.ofPrimitive(value));
        return this;
    }

    public JSONArray addValue(Number value) {
        this.add(this.factory.ofPrimitive(value));
        return this;
    }

    public JSONArray addValue(Character value) {
        this.add(this.factory.ofPrimitive(value));
        return this;
    }

    public JSONArray addValue(String value) {
        this.add(this.factory.ofPrimitive(value));
        return this;
    }

    public JSONArray addValue(Object value) {
        this.add(this.factory.getMapper().toJSON(value, false));
        return this;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.size() == 0 || this.size() == 0) {
            return null;
        }
        JSONObject jo = this.factory.ofObj();
        for (int i = 0; i < names.size(); ++i) {
            jo.putValue(names.getStr(i), this.getObj(i));
        }
        return jo;
    }

    @Override
    public Iterator<JSON> iterator() {
        return ((List)this.raw).iterator();
    }

    @Override
    public boolean addAll(int index, Collection<? extends JSON> c) {
        if (CollUtil.isEmpty(c)) {
            return false;
        }
        ArrayList<JSON> list = new ArrayList<JSON>(c.size());
        for (JSON jSON : c) {
            if (null == jSON && this.config().isIgnoreNullElement()) continue;
            list.add(jSON);
        }
        return ((List)this.raw).addAll(index, list);
    }

    public JSONArray setValue(int index, Object element) {
        this.set(index, this.factory.getMapper().toJSON(element, false));
        return this;
    }

    @Override
    public JSON set(int index, JSON element) {
        if (null == element && this.config().isIgnoreNullElement()) {
            return null;
        }
        int size = this.size();
        if (index == size) {
            this.add(element);
            return null;
        }
        if (index > size) {
            this.add(index, element);
            return null;
        }
        return ((List)this.raw).set(index, element);
    }

    @Override
    public boolean add(JSON element) {
        if (null == element && this.config().isIgnoreNullElement()) {
            return false;
        }
        return super.add(element);
    }

    @Override
    public void add(int index, JSON element) {
        boolean ignoreNullValue = this.config().isIgnoreNullElement();
        if (null == element && ignoreNullValue) {
            return;
        }
        if (index < this.size()) {
            if (index < 0) {
                index = 0;
            }
            ((List)this.raw).add(index, element);
        } else {
            if (!ignoreNullValue) {
                Validator.checkIndexLimit(index, (this.size() + 1) * 10);
                while (index != this.size()) {
                    this.add(null);
                }
            }
            this.add(element);
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return (Object[])ArrayTypeAdapter.INSTANCE.deserialize((JSON)this, a.getClass().getComponentType());
    }

    public Object toArray(Class<?> arrayClass) {
        return ArrayTypeAdapter.INSTANCE.deserialize((JSON)this, arrayClass.getComponentType());
    }

    public <T> List<T> toList(Class<T> elementType) {
        return (List)IterTypeAdapter.INSTANCE.deserialize(this, ArrayList.class, elementType);
    }

    public String toString() {
        return this.toJSONString(0);
    }

    @Override
    public void write(JSONWriter writer) throws JSONException {
        writer.beginArray();
        CollUtil.forEach(this, (index, value) -> writer.writeField(new MutableEntry<Object, Object>(index, value)));
        writer.endArray();
    }
}

