/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing.img;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.file.FileTypeUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.swing.img.ImgUtil;
import org.dromara.hutool.swing.img.color.ColorUtil;

public class BackgroundRemoval {
    public static String[] IMAGES_TYPE = new String[]{"jpg", "jpeg", "png"};

    public static void backgroundRemoval(String inputPath, String outputPath, int tolerance) {
        BackgroundRemoval.backgroundRemoval(new File(inputPath), new File(outputPath), tolerance);
    }

    public static void backgroundRemoval(File input, File output, int tolerance) {
        BackgroundRemoval.backgroundRemoval(input, output, null, tolerance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backgroundRemoval(File input, File output, Color override, int tolerance) {
        BackgroundRemoval.fileTypeValidation(input, IMAGES_TYPE);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImgUtil.read(input);
            ImgUtil.write(BackgroundRemoval.backgroundRemoval(bufferedImage, override, tolerance), output);
        }
        finally {
            ImgUtil.flush(bufferedImage);
        }
    }

    public static BufferedImage backgroundRemoval(BufferedImage bufferedImage, Color override, int tolerance) {
        tolerance = Math.min(255, Math.max(tolerance, 0));
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        BufferedImage image = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
        Graphics graphics = image.getGraphics();
        graphics.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
        String[] removeRgb = BackgroundRemoval.getRemoveRgb(bufferedImage);
        String mainColor = BackgroundRemoval.getMainColor(bufferedImage);
        boolean alpha = false;
        for (int y = image.getMinY(); y < image.getHeight(); ++y) {
            for (int x = image.getMinX(); x < image.getWidth(); ++x) {
                boolean isTrue;
                int rgb = image.getRGB(x, y);
                String hex = ColorUtil.toHex((rgb & 0xFF0000) >> 16, (rgb & 0xFF00) >> 8, rgb & 0xFF);
                boolean bl = isTrue = ArrayUtil.contains(removeRgb, hex) || BackgroundRemoval.areColorsWithinTolerance(BackgroundRemoval.hexToRgb(mainColor), new Color(Integer.parseInt(hex.substring(1), 16)), tolerance);
                if (isTrue) {
                    rgb = override == null ? 0x1000000 | rgb & 0xFFFFFF : override.getRGB();
                }
                image.setRGB(x, y, rgb);
            }
        }
        graphics.drawImage(image, 0, 0, imageIcon.getImageObserver());
        return image;
    }

    public static BufferedImage backgroundRemoval(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        try {
            return BackgroundRemoval.backgroundRemoval(ImageIO.read(new ByteArrayInputStream(outputStream.toByteArray())), override, tolerance);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static String[] getRemoveRgb(BufferedImage image) {
        int width = image.getWidth() - 1;
        int height = image.getHeight() - 1;
        int leftUpPixel = image.getRGB(1, 1);
        String leftUp = ColorUtil.toHex((leftUpPixel & 0xFF0000) >> 16, (leftUpPixel & 0xFF00) >> 8, leftUpPixel & 0xFF);
        int upMiddlePixel = image.getRGB(width / 2, 1);
        String upMiddle = ColorUtil.toHex((upMiddlePixel & 0xFF0000) >> 16, (upMiddlePixel & 0xFF00) >> 8, upMiddlePixel & 0xFF);
        int rightUpPixel = image.getRGB(width, 1);
        String rightUp = ColorUtil.toHex((rightUpPixel & 0xFF0000) >> 16, (rightUpPixel & 0xFF00) >> 8, rightUpPixel & 0xFF);
        int rightMiddlePixel = image.getRGB(width, height / 2);
        String rightMiddle = ColorUtil.toHex((rightMiddlePixel & 0xFF0000) >> 16, (rightMiddlePixel & 0xFF00) >> 8, rightMiddlePixel & 0xFF);
        int lowerRightPixel = image.getRGB(width, height);
        String lowerRight = ColorUtil.toHex((lowerRightPixel & 0xFF0000) >> 16, (lowerRightPixel & 0xFF00) >> 8, lowerRightPixel & 0xFF);
        int lowerMiddlePixel = image.getRGB(width / 2, height);
        String lowerMiddle = ColorUtil.toHex((lowerMiddlePixel & 0xFF0000) >> 16, (lowerMiddlePixel & 0xFF00) >> 8, lowerMiddlePixel & 0xFF);
        int leftLowerPixel = image.getRGB(1, height);
        String leftLower = ColorUtil.toHex((leftLowerPixel & 0xFF0000) >> 16, (leftLowerPixel & 0xFF00) >> 8, leftLowerPixel & 0xFF);
        int leftMiddlePixel = image.getRGB(1, height / 2);
        String leftMiddle = ColorUtil.toHex((leftMiddlePixel & 0xFF0000) >> 16, (leftMiddlePixel & 0xFF00) >> 8, leftMiddlePixel & 0xFF);
        return new String[]{leftUp, upMiddle, rightUp, rightMiddle, lowerRight, lowerMiddle, leftLower, leftMiddle};
    }

    public static Color hexToRgb(String hex) {
        return new Color(Integer.parseInt(hex.substring(1), 16));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, int tolerance) {
        return BackgroundRemoval.areColorsWithinTolerance(color1, color2, new Color(tolerance, tolerance, tolerance));
    }

    public static boolean areColorsWithinTolerance(Color color1, Color color2, Color tolerance) {
        return color1.getRed() - color2.getRed() < tolerance.getRed() && color1.getRed() - color2.getRed() > -tolerance.getRed() && color1.getBlue() - color2.getBlue() < tolerance.getBlue() && color1.getBlue() - color2.getBlue() > -tolerance.getBlue() && color1.getGreen() - color2.getGreen() < tolerance.getGreen() && color1.getGreen() - color2.getGreen() > -tolerance.getGreen();
    }

    public static String getMainColor(String input) {
        return BackgroundRemoval.getMainColor(new File(input));
    }

    public static String getMainColor(File input) {
        try {
            return BackgroundRemoval.getMainColor(ImageIO.read(input));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String getMainColor(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("\u56fe\u7247\u6d41\u662f\u7a7a\u7684");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int y = bufferedImage.getMinY(); y < bufferedImage.getHeight(); ++y) {
            for (int x = bufferedImage.getMinX(); x < bufferedImage.getWidth(); ++x) {
                int pixel = bufferedImage.getRGB(x, y);
                list.add(((pixel & 0xFF0000) >> 16) + "-" + ((pixel & 0xFF00) >> 8) + "-" + (pixel & 0xFF));
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>(list.size(), 1.0f);
        for (String string : list) {
            Integer integer = (Integer)map.get(string);
            if (integer == null) {
                integer = 1;
            } else {
                Integer n = integer;
                Integer n2 = integer = Integer.valueOf(integer + 1);
            }
            map.put(string, integer);
        }
        String max = "";
        long num = 0L;
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Integer temp = (Integer)entry.getValue();
            if (!StrUtil.isBlank(max) && (long)temp.intValue() <= num) continue;
            max = key;
            num = temp.intValue();
        }
        String[] strings = max.split("-");
        int rgbLength = 3;
        if (strings.length == 3) {
            return ColorUtil.toHex(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]));
        }
        return "";
    }

    private static void fileTypeValidation(File input, String[] imagesType) {
        Assert.isTrue(input.exists(), "File {} not exist!", input);
        String type = FileTypeUtil.getType(input);
        if (!ArrayUtil.contains(imagesType, type)) {
            throw new IllegalArgumentException(StrUtil.format("Format {} of File not supported!", type));
        }
    }
}

