/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.mq.engine;

import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.extra.mq.MQConfig;
import org.dromara.hutool.extra.mq.MQException;
import org.dromara.hutool.extra.mq.engine.MQEngine;

public class MQEngineFactory {
    public static MQEngine createEngine(MQConfig config) {
        return MQEngineFactory.doCreateEngine(config);
    }

    private static MQEngine doCreateEngine(MQConfig config) {
        Class<? extends MQEngine> customEngineClass = config.getCustomEngine();
        MQEngine engine = null != customEngineClass ? (MQEngine)ConstructorUtil.newInstance(customEngineClass, (Object[])new Object[0]) : (MQEngine)SpiUtil.loadFirstAvailable(MQEngine.class);
        if (null != engine) {
            return engine.init(config);
        }
        throw new MQException("No MQ implement found! Please add one of MQ jar to your project !");
    }
}

